"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newFilterListRouteFactory = exports.editFilterListRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _locator = require("../../../../../common/constants/locator");
var _check_capabilities = require("../../../capabilities/check_capabilities");
var _check_ml_nodes = require("../../../ml_nodes_check/check_ml_nodes");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _breadcrumbs = require("../../breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/routes/settings/filter_list_new_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var MODE = /*#__PURE__*/function (MODE) {
  MODE[MODE["NEW"] = 0] = "NEW";
  MODE[MODE["EDIT"] = 1] = "EDIT";
  return MODE;
}(MODE || {});
const EditFilterList = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../../../settings/filter_lists')))).EditFilterList
}));
const newFilterListRouteFactory = navigateToApp => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.FILTER_LISTS_NEW),
  title: _i18n.i18n.translate('xpack.ml.settings.createFilter.docTitle', {
    defaultMessage: 'Create Filter'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    mode: MODE.NEW,
    deps: deps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 28
    }
  })),
  breadcrumbs: [...(0, _breadcrumbs.getADSettingsBreadcrumbs)(navigateToApp), (0, _breadcrumbs.getMlManagementBreadcrumb)('FILTER_LISTS_MANAGEMENT_BREADCRUMB', navigateToApp), {
    text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.filterLists.createLabel', {
      defaultMessage: 'Create'
    })
  }]
});
exports.newFilterListRouteFactory = newFilterListRouteFactory;
const editFilterListRouteFactory = navigateToApp => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.FILTER_LISTS_EDIT, '/:filterId'),
  title: _i18n.i18n.translate('xpack.ml.settings.editFilter.docTitle', {
    defaultMessage: 'Edit Filter'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    mode: MODE.EDIT,
    deps: deps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 28
    }
  })),
  breadcrumbs: [...(0, _breadcrumbs.getADSettingsBreadcrumbs)(navigateToApp), {
    text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.filterLists.editLabel', {
      defaultMessage: 'Edit'
    })
  }]
});
exports.editFilterListRouteFactory = editFilterListRouteFactory;
const PageWrapper = ({
  location,
  mode
}) => {
  let filterId;
  if (mode === MODE.EDIT) {
    const pathMatch = location.pathname.match(/.+\/(.+)$/);
    filterId = pathMatch && pathMatch.length > 1 ? pathMatch[1] : undefined;
  }
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetFilters', 'canCreateFilter'], {
    getMlNodeCount: _check_ml_nodes.getMlNodeCount
  });
  (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: false
  });
  const [canCreateFilter, canDeleteFilter] = (0, _check_capabilities.usePermissionCheck)(['canCreateFilter', 'canDeleteFilter']);
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(EditFilterList, {
    filterId,
    canCreateFilter,
    canDeleteFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }));
};