"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedModel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _ner = require("./models/ner");
var _question_answering = require("./models/question_answering");
var _text_classification = require("./models/text_classification");
var _text_embedding = require("./models/text_embedding");
var _kibana = require("../../contexts/kibana");
var _inference_input_form = require("./models/inference_input_form");
var _text_expansion = require("./models/text_expansion");
var _get_inference_properties_from_pipeline_config = require("../create_pipeline_for_model/get_inference_properties_from_pipeline_config");
var _ml_telemetry_context = require("../../contexts/ml/ml_telemetry_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/test_models/selected_model.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SelectedModel = ({
  model,
  inputType,
  deploymentId,
  handlePipelineConfigUpdate,
  externalPipelineConfig,
  setCurrentContext
}) => {
  const {
    trainedModels
  } = (0, _kibana.useMlApi)();
  const {
    telemetryClient
  } = (0, _ml_telemetry_context.useMlTelemetryClient)();
  const inferrer = (0, _react.useMemo)(() => {
    var _model$inference_conf;
    const taskType = Object.keys((_model$inference_conf = model.inference_config) !== null && _model$inference_conf !== void 0 ? _model$inference_conf : {})[0];
    let tempInferrer;
    const pipelineConfigValues = externalPipelineConfig ? (0, _get_inference_properties_from_pipeline_config.getInferencePropertiesFromPipelineConfig)(taskType, externalPipelineConfig) : null;
    if (model.model_type === _mlTrainedModelsUtils.TRAINED_MODEL_TYPE.PYTORCH) {
      switch (taskType) {
        case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.NER:
          tempInferrer = new _ner.NerInference(trainedModels, model, inputType, deploymentId, telemetryClient);
          break;
        case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_CLASSIFICATION:
          tempInferrer = new _text_classification.TextClassificationInference(trainedModels, model, inputType, deploymentId, telemetryClient);
          break;
        case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.ZERO_SHOT_CLASSIFICATION:
          tempInferrer = new _text_classification.ZeroShotClassificationInference(trainedModels, model, inputType, deploymentId, telemetryClient);
          if (pipelineConfigValues) {
            const {
              labels,
              multi_label: multiLabel
            } = pipelineConfigValues;
            if (labels && multiLabel !== undefined) {
              tempInferrer.setLabelsText(Array.isArray(labels) ? labels.join(',') : labels);
              tempInferrer.setMultiLabel(Boolean(multiLabel));
            }
          }
          break;
        case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_EMBEDDING:
          tempInferrer = new _text_embedding.TextEmbeddingInference(trainedModels, model, inputType, deploymentId, telemetryClient);
          break;
        case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.FILL_MASK:
          tempInferrer = new _text_classification.FillMaskInference(trainedModels, model, inputType, deploymentId, telemetryClient);
          break;
        case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.QUESTION_ANSWERING:
          tempInferrer = new _question_answering.QuestionAnsweringInference(trainedModels, model, inputType, deploymentId, telemetryClient);
          if (pipelineConfigValues !== null && pipelineConfigValues !== void 0 && pipelineConfigValues.question) {
            tempInferrer.setQuestionText(pipelineConfigValues.question);
          }
          break;
        case _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_EXPANSION:
          tempInferrer = new _text_expansion.TextExpansionInference(trainedModels, model, inputType, deploymentId, telemetryClient);
          break;
        default:
          break;
      }
    } else if (model.model_type === _mlTrainedModelsUtils.TRAINED_MODEL_TYPE.LANG_IDENT) {
      tempInferrer = new _text_classification.LangIdentInference(trainedModels, model, inputType, deploymentId, telemetryClient);
    }
    if (tempInferrer) {
      if (pipelineConfigValues) {
        tempInferrer.setInputField(pipelineConfigValues.inputField);
      }
      if (externalPipelineConfig === undefined) {
        tempInferrer.setSwitchtoCreationMode(() => {
          if (tempInferrer && setCurrentContext) {
            setCurrentContext({
              pipelineConfig: tempInferrer.getPipeline(),
              defaultSelectedDataViewId: tempInferrer.getSelectedDataViewId(),
              createPipelineFlyoutOpen: true
            });
          }
        });
      } else {
        var _tempInferrer;
        (_tempInferrer = tempInferrer) === null || _tempInferrer === void 0 ? void 0 : _tempInferrer.getPipeline$().subscribe(testPipeline => {
          if (handlePipelineConfigUpdate && testPipeline && externalPipelineConfig) {
            const {
              fieldMap: testFieldMap,
              inferenceConfig: testInferenceConfig,
              labels,
              multi_label: multiLabel,
              question
            } = (0, _get_inference_properties_from_pipeline_config.getInferencePropertiesFromPipelineConfig)(taskType, testPipeline);
            const updatedPipeline = (0, _lodash.cloneDeep)(externalPipelineConfig);
            const {
              inferenceObj: externalInference,
              inferenceConfig: externalInferenceConfig
            } = (0, _get_inference_properties_from_pipeline_config.getInferencePropertiesFromPipelineConfig)(taskType, updatedPipeline);
            if (externalInference) {
              // Always update target field change
              externalInference.field_map = testFieldMap;
              if (externalInferenceConfig === undefined) {
                externalInference.inference_config = testInferenceConfig;
              } else if ((0, _get_inference_properties_from_pipeline_config.isMlIngestInferenceProcessor)(externalInference) && (0, _get_inference_properties_from_pipeline_config.isMlInferencePipelineInferenceConfig)(externalInference.inference_config)) {
                // Only update the properties that change in the test step to avoid overwriting user edits
                if (taskType === _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.ZERO_SHOT_CLASSIFICATION && labels && multiLabel !== undefined) {
                  const external = externalInference.inference_config[_mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.ZERO_SHOT_CLASSIFICATION];
                  if (external) {
                    external.multi_label = multiLabel;
                    external.labels = labels;
                  }
                } else if (taskType === _mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.QUESTION_ANSWERING && question !== undefined) {
                  const external = externalInference.inference_config[_mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.QUESTION_ANSWERING];
                  if (external) {
                    external.question = question;
                  }
                }
              }
            }
            handlePipelineConfigUpdate({
              initialPipelineConfig: updatedPipeline
            });
          }
        });
      }
    }
    return tempInferrer;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [inputType, model, trainedModels, deploymentId, setCurrentContext]);
  (0, _react.useEffect)(() => {
    return () => {
      inferrer === null || inferrer === void 0 ? void 0 : inferrer.destroy();
    };
  }, [inferrer, model.model_id]);
  if (inferrer !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_inference_input_form.InferenceInputForm, {
      inferrer: inferrer,
      inputType: inputType,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 12
      }
    });
  }
  return null;
};
exports.SelectedModel = SelectedModel;