"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultAnomalyDetectionJobsListState = exports.JobsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlUrlState = require("@kbn/ml-url-state");
var _jobs_list_view = require("./components/jobs_list_view");
var _locator = require("../../../../common/constants/locator");
var _help_menu = require("../../components/help_menu");
var _kibana = require("../../contexts/kibana");
var _page_header = require("../../components/page_header");
var _header_menu_portal = require("../../components/header_menu_portal");
var _jobs_action_menu = require("../components/jobs_action_menu");
var _ml = require("../../contexts/ml");
var _check_ml_nodes = require("../../ml_nodes_check/check_ml_nodes");
var _top_level_actions = require("./components/top_level_actions");
var _new_job_button = require("./components/new_job_button");
var _check_capabilities = require("../../capabilities/check_capabilities");
var _import_jobs_flyout = require("../../components/import_export_jobs/import_jobs_flyout");
var _import_export_jobs = require("../../components/import_export_jobs");
var _page_title = require("../../components/page_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/jobs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getDefaultAnomalyDetectionJobsListState = () => ({
  pageIndex: 0,
  pageSize: 10,
  sortField: 'id',
  sortDirection: 'asc'
});
exports.getDefaultAnomalyDetectionJobsListState = getDefaultAnomalyDetectionJobsListState;
const JobsPage = ({
  isMlEnabledInSpace,
  lastRefresh,
  refreshList
}) => {
  const [pageState, setPageState] = (0, _mlUrlState.usePageUrlState)(_locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE_FOR_URL, getDefaultAnomalyDetectionJobsListState());
  const {
    services: {
      docLinks,
      mlServices: {
        mlApi
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  (0, _check_ml_nodes.getMlNodeCount)(mlApi);
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const helpLink = docLinks.links.ml.anomalyDetection;
  const [canCreateJob] = (0, _check_capabilities.usePermissionCheck)(['canCreateJob']);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, {
    wrapHeader: true,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_top_level_actions.SuppliedConfigurationsButton, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_top_level_actions.AnomalyDetectionSettingsButton, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_top_level_actions.SynchronizeSavedObjectsButton, {
      refreshJobs: refreshList,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_import_export_jobs.ExportJobsFlyout, {
      isDisabled: !canCreateJob,
      currentTab: 'anomaly-detector',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_import_jobs_flyout.ImportJobsFlyout, {
      isDisabled: !canCreateJob,
      onImportComplete: refreshList,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_new_job_button.NewJobButton, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.title",
      defaultMessage: "Anomaly Detection Jobs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_header_menu_portal.HeaderMenuPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_jobs_action_menu.JobsActionMenu, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_jobs_list_view.JobsListView, {
    euiTheme: euiTheme,
    isMlEnabledInSpace: isMlEnabledInSpace,
    lastRefresh: lastRefresh,
    jobsViewState: pageState,
    onJobsViewStateUpdate: setPageState,
    showNodeInfo: showNodeInfo,
    canCreateJob: canCreateJob,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }));
};
exports.JobsPage = JobsPage;