"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobStatsBar = void 0;
var _states = require("../../../../../../common/constants/states");
var _stats_bar = require("../../../../components/stats_bar");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/jobs_stats_bar/jobs_stats_bar.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function createJobStats(jobsSummaryList, showNodeInfo) {
  const jobStats = {
    ...(showNodeInfo ? {
      activeNodes: {
        label: _i18n.i18n.translate('xpack.ml.jobsList.statsBar.activeMLNodesLabel', {
          defaultMessage: 'Active ML nodes'
        }),
        value: 0,
        show: true
      }
    } : {}),
    total: {
      label: _i18n.i18n.translate('xpack.ml.jobsList.statsBar.totalJobsLabel', {
        defaultMessage: 'Total jobs'
      }),
      value: 0,
      show: true
    },
    open: {
      label: _i18n.i18n.translate('xpack.ml.jobsList.statsBar.openJobsLabel', {
        defaultMessage: 'Open jobs'
      }),
      value: 0,
      show: true
    },
    closed: {
      label: _i18n.i18n.translate('xpack.ml.jobsList.statsBar.closedJobsLabel', {
        defaultMessage: 'Closed jobs'
      }),
      value: 0,
      show: true
    },
    failed: {
      label: _i18n.i18n.translate('xpack.ml.jobsList.statsBar.failedJobsLabel', {
        defaultMessage: 'Failed jobs'
      }),
      value: 0,
      show: false
    },
    activeDatafeeds: {
      label: _i18n.i18n.translate('xpack.ml.jobsList.statsBar.activeDatafeedsLabel', {
        defaultMessage: 'Active datafeeds'
      }),
      value: 0,
      show: true
    }
  };
  if (jobsSummaryList === undefined) {
    return jobStats;
  }

  // object to keep track of nodes being used by jobs
  const mlNodes = {};
  let failedJobs = 0;
  jobsSummaryList.forEach(job => {
    if (job.jobState === _states.JOB_STATE.OPENED) {
      jobStats.open.value++;
    } else if (job.jobState === _states.JOB_STATE.CLOSED) {
      jobStats.closed.value++;
    } else if (job.jobState === _states.JOB_STATE.FAILED) {
      failedJobs++;
    }
    if (job.hasDatafeed && job.datafeedState === _states.DATAFEED_STATE.STARTED) {
      jobStats.activeDatafeeds.value++;
    }
    if (job.nodeName !== undefined) {
      mlNodes[job.nodeName] = {};
    }
  });
  jobStats.total.value = jobsSummaryList.length;

  // // Only show failed jobs if it is non-zero
  if (failedJobs) {
    jobStats.failed.value = failedJobs;
    jobStats.failed.show = true;
  } else {
    jobStats.failed.show = false;
  }
  if (showNodeInfo) {
    jobStats.activeNodes.value = Object.keys(mlNodes).length;
  }
  return jobStats;
}
const JobStatsBar = ({
  jobsSummaryList,
  showNodeInfo
}) => {
  const jobStats = createJobStats(jobsSummaryList, showNodeInfo);
  return /*#__PURE__*/_react.default.createElement(_stats_bar.StatsBar, {
    stats: jobStats,
    dataTestSub: 'mlJobStatsBar',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 10
    }
  });
};
exports.JobStatsBar = JobStatsBar;
JobStatsBar.propTypes = {
  jobsSummaryList: _propTypes.default.array.isRequired,
  showNodeInfo: _propTypes.default.bool.isRequired
};