"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobsActionMenu = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../contexts/kibana");
var _locator = require("../../../../../common/constants/locator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/components/jobs_action_menu/jobs_action_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const JobsActionMenu = () => {
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const mlLocator = (0, _kibana.useMlLocator)();
  const onClick = async () => {
    if (!mlLocator) return;
    const path = await mlLocator.getUrl({
      page: _locator.ML_PAGES.SETTINGS
    });
    navigateToPath(path);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClick,
    iconType: "gear",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.navMenu.settingsTabLinkText",
    defaultMessage: "Settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }));
};
exports.JobsActionMenu = JobsActionMenu;