"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityLegendControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _select_severity = require("../../../components/controls/select_severity");
var _severity_legend_control_styles = require("./severity_legend_control_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/components/severity_legend_control/severity_legend_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SeverityLegendControl = ({
  allSeverityOptions,
  selectedSeverities,
  onChange,
  dataTestSubj = 'severity-legend-control'
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _severity_legend_control_styles.useSeverityLegendControlStyles)();
  const handleSeverityClick = (0, _react.useCallback)(clickedSeverity => {
    const isCurrentlySelected = selectedSeverities.some(severity => severity.val === clickedSeverity.val);
    const allSelected = selectedSeverities.length === allSeverityOptions.length;
    let newSelectedSeverities;

    // If all are selected, select only the clicked one
    if (allSelected) {
      newSelectedSeverities = [clickedSeverity];
    }
    // If trying to deselect the last selected option, select all instead
    else if (isCurrentlySelected && selectedSeverities.length === 1) {
      newSelectedSeverities = [...allSeverityOptions];
    }
    // If deselecting one of multiple selected options
    else if (isCurrentlySelected) {
      newSelectedSeverities = selectedSeverities.filter(severity => severity.val !== clickedSeverity.val);
    }
    // If selecting an additional option
    else {
      newSelectedSeverities = [...selectedSeverities, clickedSeverity];
    }
    onChange(newSelectedSeverities);
  }, [selectedSeverities, allSeverityOptions, onChange]);
  const severityControl = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, allSeverityOptions.map(severity => {
    const isSelected = selectedSeverities.some(s => s.val === severity.val);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: severity.val,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: () => handleSeverityClick(severity),
      css: styles.severityButton,
      "data-test-subj": `${dataTestSubj}-item-${severity.val}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: isSelected ? 'dot' : 'eyeClosed',
      color: isSelected ? severity.color : euiTheme.colors.textDisabled,
      size: isSelected ? 'm' : 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      css: styles.severityText(isSelected),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 19
      }
    }, (0, _select_severity.getSeverityRangeDisplay)(severity.val))))));
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    compressed: true,
    prepend: _i18n.i18n.translate('xpack.ml.explorer.severityLegendControl.anomalyScoreLabel', {
      defaultMessage: 'Anomaly score'
    }),
    fullWidth: true,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.severityControl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, severityControl));
};
exports.SeverityLegendControl = SeverityLegendControl;