"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EvaluatePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _kibana = require("../../../../../contexts/kibana");
var _vega_chart = require("../../../../../components/vega_chart");
var _vega_chart_loading = require("../../../../../components/vega_chart/vega_chart_loading");
var _error_callout = require("../error_callout");
var _expandable_section = require("../expandable_section");
var _evaluate_stat = require("./evaluate_stat");
var _evaluation_quality_metrics_table = require("./evaluation_quality_metrics_table");
var _get_roc_curve_chart_vega_lite_spec = require("./get_roc_curve_chart_vega_lite_spec");
var _column_data = require("./column_data");
var _is_training_filter = require("./is_training_filter");
var _use_roc_curve = require("./use_roc_curve");
var _use_confusion_matrix = require("./use_confusion_matrix");
var _confusion_matrix_help_popover = require("./confusion_matrix_help_popover");
var _roc_curve_help_popover = require("./roc_curve_help_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/classification_exploration/evaluate_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Separate imports for lazy loadable VegaChart and related code
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var SUBSET_TITLE = /*#__PURE__*/function (SUBSET_TITLE) {
  SUBSET_TITLE["TRAINING"] = "training";
  SUBSET_TITLE["TESTING"] = "testing";
  SUBSET_TITLE["ENTIRE"] = "entire";
  return SUBSET_TITLE;
}(SUBSET_TITLE || {});
const entireDatasetHelpText = _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.confusionMatrixEntireHelpText', {
  defaultMessage: 'Normalized confusion matrix for entire dataset'
});
const testingDatasetHelpText = _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.confusionMatrixTestingHelpText', {
  defaultMessage: 'Normalized confusion matrix for testing dataset'
});
const trainingDatasetHelpText = _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.confusionMatrixTrainingHelpText', {
  defaultMessage: 'Normalized confusion matrix for training dataset'
});
const evaluationQualityMetricsHelpText = _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.evaluationQualityMetricsHelpText', {
  defaultMessage: 'Evaluation quality metrics'
});
function getHelpText(dataSubsetTitle) {
  let helpText = entireDatasetHelpText;
  if (dataSubsetTitle === SUBSET_TITLE.TESTING) {
    helpText = testingDatasetHelpText;
  } else if (dataSubsetTitle === SUBSET_TITLE.TRAINING) {
    helpText = trainingDatasetHelpText;
  }
  return helpText;
}
const EvaluatePanel = ({
  jobConfig,
  jobStatus,
  searchQuery
}) => {
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [columns, setColumns] = (0, _react.useState)([]);
  const [columnsData, setColumnsData] = (0, _react.useState)([]);
  const [showFullColumns, setShowFullColumns] = (0, _react.useState)(false);
  const [dataSubsetTitle, setDataSubsetTitle] = (0, _react.useState)(SUBSET_TITLE.ENTIRE);
  // Column visibility
  const [visibleColumns, setVisibleColumns] = (0, _react.useState)(() => columns.map(({
    id
  }) => id));
  const resultsField = jobConfig.dest.results_field;
  const isTraining = (0, _is_training_filter.isTrainingFilter)(searchQuery, resultsField);
  const {
    avgRecall,
    confusionMatrixData,
    docsCount,
    error: errorConfusionMatrix,
    isLoading: isLoadingConfusionMatrix,
    overallAccuracy,
    evaluationMetricsItems
  } = (0, _use_confusion_matrix.useConfusionMatrix)(jobConfig, searchQuery);
  (0, _react.useEffect)(() => {
    if (isTraining === undefined) {
      setDataSubsetTitle(SUBSET_TITLE.ENTIRE);
    } else {
      setDataSubsetTitle(isTraining && isTraining === true ? SUBSET_TITLE.TRAINING : SUBSET_TITLE.TESTING);
    }
  }, [isTraining]);
  (0, _react.useEffect)(() => {
    if (confusionMatrixData.length > 0) {
      const {
        columns: derivedColumns,
        columnData
      } = (0, _column_data.getColumnData)(confusionMatrixData);
      // Initialize all columns as visible
      setVisibleColumns(() => derivedColumns.map(({
        id
      }) => id));
      setColumns(derivedColumns);
      setColumnsData(columnData);
    }
  }, [confusionMatrixData]);
  const {
    rocCurveData,
    classificationClasses,
    error: errorRocCurve,
    isLoading: isLoadingRocCurve
  } = (0, _use_roc_curve.useRocCurve)(jobConfig, searchQuery, columns.map(d => d.id));
  const renderCellValue = ({
    rowIndex,
    columnId,
    setCellProps,
    schema,
    isDetails
  }) => {
    const cellValue = columnId === _column_data.ACTUAL_CLASS_ID ? columnsData[rowIndex][columnId] : columnsData[rowIndex].predicted_classes_count[columnId];
    const actualCount = columnsData[rowIndex] && columnsData[rowIndex].actual_class_doc_count;
    let accuracy = '0%';
    if (columnId !== _column_data.ACTUAL_CLASS_ID && actualCount && typeof cellValue === 'number') {
      let accuracyNumber = cellValue / actualCount;
      // round to 2 decimal places without converting to string;
      accuracyNumber = Math.round(accuracyNumber * 100) / 100;
      accuracy = `${Math.round(accuracyNumber * 100)}%`;
    }

    // eslint-disable-next-line react-hooks/rules-of-hooks
    (0, _react.useEffect)(() => {
      if (columnId !== _column_data.ACTUAL_CLASS_ID) {
        setCellProps({
          style: {
            backgroundColor: `rgba(0, 179, 164, ${accuracy})`
          }
        });
      }
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [rowIndex, columnId, setCellProps]);
    let cellContent = columnId === _column_data.ACTUAL_CLASS_ID ? cellValue : accuracy;

    // Custom popover content for numeric schemas
    if (isDetails && schema === 'numeric') {
      const gridItem = columnsData[rowIndex];
      if (gridItem !== undefined && columnId !== _column_data.ACTUAL_CLASS_ID) {
        const count = gridItem.predicted_classes_count[columnId];
        cellContent = `${count} / ${gridItem.actual_class_doc_count} * 100 = ${cellContent}`;
      }
    }
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 12
      }
    }, cellContent);
  };
  const docLink = docLinks.links.ml.classificationEvaluation;
  const showTrailingColumns = columnsData.length > _column_data.MAX_COLUMNS;
  const extraColumns = columnsData.length - _column_data.MAX_COLUMNS;
  const shownColumns = showTrailingColumns === true && showFullColumns === false ? columns.slice(0, _column_data.MAX_COLUMNS + 1) : columns;
  const rowCount = showTrailingColumns === true && showFullColumns === false ? _column_data.MAX_COLUMNS : columnsData.length;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    urlStateKey: 'evaluation',
    dataTestId: "ClassificationEvaluation",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.classificationExploration.evaluateSectionTitle",
      defaultMessage: "Model evaluation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 11
      }
    }),
    docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      target: "_blank",
      iconType: "question",
      iconSide: "left",
      size: "xs",
      color: "primary",
      href: docLink,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.classificationExploration.classificationDocsLink",
      defaultMessage: "Classification evaluation docs ",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 15
      }
    }))),
    headerItems: !isLoadingConfusionMatrix ? [...(jobStatus !== undefined ? [{
      id: 'jobStatus',
      label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.evaluateJobStatusLabel', {
        defaultMessage: 'Job status'
      }),
      value: jobStatus
    }] : []), ...(docsCount !== null ? [{
      id: 'docsEvaluated',
      label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.generalizationDocsCount', {
        defaultMessage: '{docsCount, plural, one {doc} other {docs}} evaluated',
        values: {
          docsCount
        }
      }),
      value: docsCount
    }] : [])] : _expandable_section.HEADER_ITEMS_LOADING,
    contentPadding: true,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      css: {
        width: '80%'
      },
      gutterSize: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 296,
        columnNumber: 15
      }
    }, !isLoadingConfusionMatrix ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errorConfusionMatrix !== null && /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
      error: errorConfusionMatrix,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 55
      }
    }), errorConfusionMatrix === null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 305,
        columnNumber: 29
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 31
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 33
      }
    }, getHelpText(dataSubsetTitle)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 29
      }
    }, /*#__PURE__*/_react.default.createElement(_confusion_matrix_help_popover.MulticlassConfusionMatrixHelpPopover, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 311,
        columnNumber: 31
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 316,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      justifyContent: "spaceAround",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 317,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 322,
        columnNumber: 29
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 323,
        columnNumber: 31
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.classificationExploration.confusionMatrixActualLabel",
      defaultMessage: "Actual class",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 324,
        columnNumber: 33
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 330,
        columnNumber: 29
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 331,
        columnNumber: 31
      }
    }, columns.length > 0 && columnsData.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 334,
        columnNumber: 37
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 335,
        columnNumber: 39
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.classificationExploration.confusionMatrixPredictedLabel",
      defaultMessage: "Predicted class",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 336,
        columnNumber: 41
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 342,
        columnNumber: 37
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
      "data-test-subj": "mlDFAnalyticsClassificationExplorationConfusionMatrix",
      "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.confusionMatrixLabel', {
        defaultMessage: 'Classification confusion matrix'
      }),
      columns: shownColumns,
      columnVisibility: {
        visibleColumns,
        setVisibleColumns
      },
      rowCount: rowCount,
      renderCellValue: renderCellValue,
      inMemory: {
        level: 'sorting'
      },
      toolbarVisibility: {
        showColumnSelector: true,
        showDisplaySelector: false,
        showFullScreenSelector: false,
        showSortSelector: false
      },
      gridStyle: {
        border: 'all',
        fontSize: 's',
        cellPadding: 's',
        stripes: false,
        rowHover: 'none',
        header: 'shade'
      },
      trailingControlColumns: showTrailingColumns === true && showFullColumns === false ? (0, _column_data.getTrailingControlColumns)(extraColumns, setShowFullColumns) : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 343,
        columnNumber: 39
      }
    }))) : null)))))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 392,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 394,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 395,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 397,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 398,
        columnNumber: 21
      }
    }, evaluationQualityMetricsHelpText))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 401,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 403,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 404,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAEvaluateSectionOverallAccuracyStat',
      title: overallAccuracy,
      isLoading: isLoadingConfusionMatrix,
      description: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.evaluateSectionOverallAccuracyStat', {
        defaultMessage: 'Overall accuracy'
      }),
      tooltipContent: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.evaluateSectionOverallAccuracyTooltip', {
        defaultMessage: 'The ratio of the number of correct class predictions to the total number of predictions.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 405,
        columnNumber: 23
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 424,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_evaluate_stat.EvaluateStat, {
      dataTestSubj: 'mlDFAEvaluateSectionAvgRecallStat',
      title: avgRecall,
      isLoading: isLoadingConfusionMatrix,
      description: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.evaluateSectionMeanRecallStat', {
        defaultMessage: 'Mean recall'
      }),
      tooltipContent: _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.evaluateSectionAvgRecallTooltip', {
        defaultMessage: 'Mean recall shows how many of the data points that are actual class members were identified correctly as class members.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 425,
        columnNumber: 23
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 446,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 447,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_evaluation_quality_metrics_table.EvaluationQualityMetricsTable, {
      evaluationMetricsItems: evaluationMetricsItems,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 448,
        columnNumber: 19
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 452,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 454,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 455,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 456,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 457,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 458,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analytics.classificationExploration.evaluateSectionRocTitle",
      defaultMessage: "Receiver operating characteristic (ROC) curve",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 459,
        columnNumber: 25
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 465,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_roc_curve_help_popover.RocCurveHelpPopover, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 466,
        columnNumber: 23
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 470,
        columnNumber: 17
      }
    }, Array.isArray(errorRocCurve) && /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
      error: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errorRocCurve.map(e => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, e, /*#__PURE__*/_react.default.createElement("br", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 478,
          columnNumber: 31
        }
      })))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 472,
        columnNumber: 21
      }
    }), !isLoadingRocCurve && errorRocCurve === null && rocCurveData.length > 0 && /*#__PURE__*/_react.default.createElement("div", {
      className: "mlDataFrameAnalyticsClassification__evaluateSectionContent",
      "data-test-subj": "mlDFAnalyticsClassificationExplorationRocCurveChart",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 486,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_vega_chart.VegaChart, {
      vegaSpec: (0, _get_roc_curve_chart_vega_lite_spec.getRocCurveChartVegaLiteSpec)(classificationClasses, rocCurveData, (0, _mlDataFrameAnalyticsUtils.getDependentVar)(jobConfig.analysis), euiTheme),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 490,
        columnNumber: 23
      }
    })), isLoadingRocCurve && /*#__PURE__*/_react.default.createElement(_vega_chart_loading.VegaChartLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 500,
        columnNumber: 41
      }
    }))))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 507,
      columnNumber: 7
    }
  }));
};
exports.EvaluatePanel = EvaluatePanel;