"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlEntitySelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _kibana = require("../../contexts/kibana");
var _toast_notification_service = require("../../services/toast_notification_service");
var _ml = require("../../contexts/ml");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/ml_entity_selector/ml_entity_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultEntities = {
  anomaly_detector: true,
  data_frame_analytics: true,
  trained_models: true
};

/**
 * Reusable component for picking ML entities.
 *
 * @param entityTypes
 * @param multiSelect
 * @param selectedOptions
 * @param onSelectionChange
 * @param handleDuplicates
 * @constructor
 */
const MlEntitySelector = ({
  entityTypes = defaultEntities,
  multiSelect = true,
  selectedOptions,
  onSelectionChange,
  handleDuplicates = false
}) => {
  const {
    isADEnabled,
    isDFAEnabled,
    isNLPEnabled
  } = (0, _ml.useEnabledFeatures)();
  const {
    jobs: jobsApi,
    trainedModels,
    dataFrameAnalytics
  } = (0, _kibana.useMlApi)();
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const visColorsBehindText = (0, _eui.euiPaletteColorBlindBehindText)();
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [options, setOptions] = (0, _react.useState)([]);
  const fetchOptions = (0, _react.useCallback)(async () => {
    try {
      const newOptions = [];
      if (isADEnabled && entityTypes !== null && entityTypes !== void 0 && entityTypes.anomaly_detector) {
        const {
          jobIds: jobIdOptions
        } = await jobsApi.getAllJobAndGroupIds();
        newOptions.push({
          label: _i18n.i18n.translate('xpack.ml.mlEntitySelector.adOptionsLabel', {
            defaultMessage: 'Anomaly detection jobs'
          }),
          isGroupLabelOption: true,
          color: visColorsBehindText[0],
          options: jobIdOptions.map(adId => ({
            label: adId,
            value: adId,
            id: `anomaly_detector:${adId}`,
            key: `anomaly_detector:${adId}`,
            color: visColorsBehindText[0],
            'data-test-subj': `mlAdJobOption`
          }))
        });
      }
      if (isDFAEnabled && entityTypes !== null && entityTypes !== void 0 && entityTypes.data_frame_analytics) {
        const dfa = await dataFrameAnalytics.getDataFrameAnalytics();
        if (dfa.count > 0) {
          newOptions.push({
            label: _i18n.i18n.translate('xpack.ml.mlEntitySelector.dfaOptionsLabel', {
              defaultMessage: 'Data frame analytics'
            }),
            isGroupLabelOption: true,
            options: dfa.data_frame_analytics.map(({
              id: dfaId
            }) => ({
              label: dfaId,
              value: dfaId,
              id: `data_frame_analytics:${dfaId}`,
              key: `data_frame_analytics:${dfaId}`,
              color: visColorsBehindText[2],
              'data-test-subj': `mlDfaJobOption`
            }))
          });
        }
      }
      if ((isDFAEnabled || isNLPEnabled) && entityTypes !== null && entityTypes !== void 0 && entityTypes.trained_models) {
        const models = await trainedModels.getTrainedModels();
        if (models.length > 0) {
          newOptions.push({
            label: _i18n.i18n.translate('xpack.ml.mlEntitySelector.trainedModelsLabel', {
              defaultMessage: 'Trained models'
            }),
            isGroupLabelOption: true,
            options: models.map(({
              model_id: modelId
            }) => ({
              label: modelId,
              value: modelId,
              id: `trained_models:${modelId}`,
              key: `trained_models:${modelId}`,
              color: visColorsBehindText[3],
              'data-test-subj': `mlTrainedModelOption`
            }))
          });
        }
      }
      setOptions(newOptions);
    } catch (error) {
      displayErrorToast(error, _i18n.i18n.translate('xpack.ml.mlEntitySelector.fetchError', {
        defaultMessage: 'Failed to fetch ML entities'
      }));
    }
    setIsLoading(false);
  }, [jobsApi, trainedModels, dataFrameAnalytics, entityTypes, visColorsBehindText, displayErrorToast, isADEnabled, isDFAEnabled, isNLPEnabled]);
  (0, _useMount.default)(function fetchOptionsOnMount() {
    fetchOptions();
  });
  const selectedEntities = (0, _react.useMemo)(() => {
    return (selectedOptions !== null && selectedOptions !== void 0 ? selectedOptions : []).flatMap(o => {
      const fromOptions = options.flatMap(g => g.options).filter(op => op.value === o.id);
      return fromOptions.length > 0 ? fromOptions : [{
        value: o.id,
        label: o.id,
        key: `unknown:${o.id}`,
        'data-test-subj': `mlUnknownOption ${o.id}`
      }];
    });
  }, [options, selectedOptions]);
  const onChange = (0, _react.useCallback)(selection => {
    if (!onSelectionChange) return;
    let resultSelection = selection;
    if (handleDuplicates) {
      const prevCounts = (0, _lodash.countBy)(selectedEntities, 'value');
      const currentCounts = (0, _lodash.countBy)(selection, 'value');
      resultSelection = resultSelection.filter(({
        value
      }) => {
        // If an ID with duplicates has been removed, delete all of them.
        return !(prevCounts[value] > 1 && currentCounts[value] < prevCounts[value]);
      });
    }
    onSelectionChange(resultSelection.map(s => {
      const [type] = s.key.split(':');
      return {
        id: s.value,
        type: type
      };
    }));
  }, [onSelectionChange, selectedEntities, handleDuplicates]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    autoFocus: true,
    isLoading: isLoading,
    singleSelection: !multiSelect,
    selectedOptions: selectedEntities,
    options: options,
    onChange: onChange,
    fullWidth: true,
    "data-test-subj": `mlEntitySelector_${isLoading ? 'loading' : 'loaded'}`,
    isInvalid: false,
    "aria-label": _i18n.i18n.translate('xpack.ml.mlEntitySelector.comboBoxAriaLabel', {
      defaultMessage: 'Machine learning entities'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 5
    }
  });
};
exports.MlEntitySelector = MlEntitySelector;