"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomUrlList = void 0;
exports.extractDataViewIdFromCustomUrl = extractDataViewIdFromCustomUrl;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _mlUrlState = require("@kbn/ml-url-state");
var _mlParseInterval = require("@kbn/ml-parse-interval");
var _react2 = require("@emotion/react");
var _kibana = require("../../../contexts/kibana");
var _toast_notification_service = require("../../../services/toast_notification_service");
var _custom_url_utils = require("../../../util/custom_url_utils");
var _utils = require("./utils");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/custom_urls/custom_url_editor/list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isValidTimeRange(timeRange) {
  // Allow empty timeRange string, which gives the 'auto' behaviour.
  if (timeRange === undefined || timeRange.length === 0 || timeRange === _constants.TIME_RANGE_TYPE.AUTO) {
    return true;
  }
  const interval = (0, _mlParseInterval.parseInterval)(timeRange);
  return interval !== null;
}
function findDFADataViewId(dfaJob, dataViewListItems, isPartialDFAJob) {
  var _dataViewListItems$fi;
  const sourceIndex = Array.isArray(dfaJob.source.index) ? dfaJob.source.index.join() : dfaJob.source.index;
  const indexName = isPartialDFAJob ? sourceIndex : dfaJob.dest.index;
  const backupIndexName = sourceIndex;
  const dataViewId = dataViewListItems === null || dataViewListItems === void 0 ? void 0 : (_dataViewListItems$fi = dataViewListItems.find(item => item.title === indexName)) === null || _dataViewListItems$fi === void 0 ? void 0 : _dataViewListItems$fi.id;
  if (!dataViewId) {
    var _dataViewListItems$fi2;
    return dataViewListItems === null || dataViewListItems === void 0 ? void 0 : (_dataViewListItems$fi2 = dataViewListItems.find(item => item.title === backupIndexName)) === null || _dataViewListItems$fi2 === void 0 ? void 0 : _dataViewListItems$fi2.id;
  }
  return dataViewId;
}

/**
 * Finds the data view ID for a custom URL.
 * For dashboards URLs: Returns the job's destination index data view ID.
 * Uses source index for partial DFA jobs since destination index doesn't exist yet.
 * For discover URLs: Extracts data view ID directly from the URL state.
 */
function extractDataViewIdFromCustomUrl(dfaJob, customUrl, dataViewListItems, isPartialDFAJob) {
  let dataViewId;
  if (customUrl.url_value.includes('dashboards')) {
    dataViewId = findDFADataViewId(dfaJob, dataViewListItems, isPartialDFAJob);
  } else {
    var _urlState$_a;
    const urlState = (0, _mlUrlState.parseUrlState)(customUrl.url_value);
    dataViewId = (_urlState$_a = urlState._a) === null || _urlState$_a === void 0 ? void 0 : _urlState$_a.index;
  }
  return dataViewId;
}
/*
 * React component for listing the custom URLs added to a job,
 * with buttons for testing and deleting each custom URL.
 */
const CustomUrlList = ({
  job,
  customUrls,
  onChange: setCustomUrls,
  dataViewListItems,
  isPartialDFAJob
}) => {
  const {
    services: {
      http,
      data: {
        dataViews
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const mlApi = (0, _kibana.useMlApi)();
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const [expandedUrlIndex, setExpandedUrlIndex] = (0, _react.useState)(null);
  const [showTimeRange, setShowTimeRange] = (0, _react.useState)([]);
  const styles = (0, _react.useMemo)(() => ({
    narrowField: (0, _react2.css)`
        min-width: calc(${euiTheme.size.xl} * 3);
      `,
    urlField: (0, _react2.css)`
        min-width: calc(${euiTheme.size.xxxxl} * 4);
      `,
    actionButtons: (0, _react2.css)`
        max-width: calc(${euiTheme.size.xl} * 3);
      `
  }), [euiTheme.size.xl, euiTheme.size.xxxxl]);
  const hasTimeField = (0, _react.useCallback)(async dataViewId => {
    if (!dataViewId) return false;
    try {
      const dataView = await dataViews.get(dataViewId);
      return (dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName) !== undefined && (dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName) !== '';
    } catch {
      return true;
    }
  }, [dataViews]);
  const getDiscoverTimeFieldStatus = (0, _react.useCallback)(async kibanaUrl => {
    var _urlState$_a2;
    if (!kibanaUrl.url_value.includes('discover')) {
      return undefined;
    }
    const urlState = (0, _mlUrlState.parseUrlState)(kibanaUrl.url_value);
    const dataViewId = (_urlState$_a2 = urlState._a) === null || _urlState$_a2 === void 0 ? void 0 : _urlState$_a2.index;
    return dataViewId ? await hasTimeField(dataViewId) : true;
  }, [hasTimeField]);
  const getDFATimeFieldStatus = (0, _react.useCallback)(async () => {
    const dataViewId = findDFADataViewId(job, dataViewListItems, isPartialDFAJob);
    return dataViewId ? await hasTimeField(dataViewId) : true;
  }, [dataViewListItems, hasTimeField, isPartialDFAJob, job]);
  (0, _react.useEffect)(() => {
    if (customUrls.length === 0) return;
    const checkTimeRangeVisibility = async () => {
      const results = await Promise.all(customUrls.map(async customUrl => {
        const kibanaUrl = customUrl;
        let dfaHasTimeField;
        if ((0, _mlDataFrameAnalyticsUtils.isDataFrameAnalyticsConfigs)(job) || isPartialDFAJob) {
          dfaHasTimeField = await getDFATimeFieldStatus();
        }
        const discoverHasTimeField = await getDiscoverTimeFieldStatus(kibanaUrl);

        // Anomaly Detection Jobs logic
        if (dfaHasTimeField === undefined) {
          if (kibanaUrl.url_value.includes('discover')) return discoverHasTimeField === true;
          return true; // Show for dashboards/other/unknown URLs
        }

        // Data Frame Analytics Jobs logic
        if (kibanaUrl.url_value.includes('discover')) {
          // For discover URLs: show only if both DFA and Discover have time fields
          return dfaHasTimeField === true && discoverHasTimeField === true;
        }
        if (kibanaUrl.url_value.includes('dashboards')) {
          // For dashboard URLs: show only if DFA has time field
          return dfaHasTimeField === true;
        }
        return true;
      }));
      setShowTimeRange(results);
    };
    checkTimeRangeVisibility();
  }, [customUrls, job, dataViewListItems, isPartialDFAJob, dataViews, getDFATimeFieldStatus, getDiscoverTimeFieldStatus]);
  const onLabelChange = (e, index) => {
    if (index < customUrls.length) {
      customUrls[index] = {
        ...customUrls[index],
        url_name: e.target.value
      };
      setCustomUrls([...customUrls]);
    }
  };
  const onUrlValueChange = (e, index) => {
    if (index < customUrls.length) {
      customUrls[index] = {
        ...customUrls[index],
        url_value: e.target.value
      };
      setCustomUrls([...customUrls]);
    }
  };
  const onTimeRangeChange = (e, index) => {
    if (index < customUrls.length) {
      customUrls[index] = {
        ...customUrls[index]
      };
      const timeRange = e.target.value;
      if (timeRange !== undefined && timeRange.length > 0) {
        customUrls[index].time_range = timeRange;
      } else {
        delete customUrls[index].time_range;
      }
      setCustomUrls([...customUrls]);
    }
  };
  const onDeleteButtonClick = index => {
    if (index < customUrls.length) {
      customUrls.splice(index, 1);
      setCustomUrls([...customUrls]);
    }
  };
  const onTestButtonClick = async index => {
    const customUrl = customUrls[index];
    let timefieldName = null;
    if (index < customUrls.length && ((0, _mlDataFrameAnalyticsUtils.isDataFrameAnalyticsConfigs)(job) || isPartialDFAJob) && customUrl.time_range !== undefined && customUrl.time_range !== _constants.TIME_RANGE_TYPE.AUTO) {
      const dataViewId = extractDataViewIdFromCustomUrl(job, customUrl, dataViewListItems, isPartialDFAJob);
      if (dataViewId) {
        var _dataView$timeFieldNa;
        const dataView = await dataViews.get(dataViewId);
        // DFA job url - need the timefield to test the URL.
        timefieldName = (_dataView$timeFieldNa = dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName) !== null && _dataView$timeFieldNa !== void 0 ? _dataView$timeFieldNa : null;
      }
    }
    if (index < customUrls.length) {
      try {
        const testUrl = await (0, _utils.getTestUrl)(mlApi, job, customUrl, timefieldName, undefined, isPartialDFAJob);
        (0, _custom_url_utils.openCustomUrlWindow)(testUrl, customUrl, http.basePath.get());
      } catch (error) {
        displayErrorToast(error, _i18n.i18n.translate('xpack.ml.customUrlEditorList.obtainingUrlToTestConfigurationErrorMessage', {
          defaultMessage: 'An error occurred obtaining the URL to test the configuration'
        }));
      }
    }
  };
  const customUrlRows = customUrls.map((customUrl, index) => {
    // Validate the label.
    const label = customUrl.url_name;
    const otherUrls = [...customUrls];
    otherUrls.splice(index, 1); // Don't compare label with itself.
    const isInvalidLabel = !(0, _custom_url_utils.isValidLabel)(label, otherUrls);
    const invalidLabelError = isInvalidLabel ? [_i18n.i18n.translate('xpack.ml.customUrlEditorList.labelIsNotUniqueErrorMessage', {
      defaultMessage: 'A unique label must be supplied'
    })] : [];

    // Validate the time range.
    const timeRange = customUrl.time_range;
    const isCustomTimeRange = customUrl.is_custom_time_range === true;
    const isInvalidTimeRange = !isValidTimeRange(timeRange);
    const invalidIntervalError = isInvalidTimeRange ? [_i18n.i18n.translate('xpack.ml.customUrlEditorList.invalidTimeRangeFormatErrorMessage', {
      defaultMessage: 'Invalid format'
    })] : [];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: `url_${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 347,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      "data-test-subj": `mlJobEditCustomUrlItem_${index}`,
      role: "listitem",
      "aria-labelledby": `custom-url-heading-${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 348,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      justifyContent: "spaceBetween",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 353,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 354,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      id: `custom-url-heading-${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 355,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.customUrlEditorList.customUrlHeading",
      defaultMessage: "Custom URL {indexCount}",
      values: {
        indexCount: index + 1
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 356,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 363,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "xs",
      css: styles.actionButtons,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 364,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 365,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.customUrlEditorList.testCustomUrlTooltip",
        defaultMessage: "Test custom URL",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 368,
          columnNumber: 23
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 366,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      color: "primary",
      onClick: () => onTestButtonClick(index),
      iconType: "popout",
      "aria-label": _i18n.i18n.translate('xpack.ml.customUrlEditorList.testCustomUrlAriaLabel', {
        defaultMessage: 'Test custom URL'
      }),
      "data-test-subj": "mlJobEditTestCustomUrlButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 374,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 389,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 390,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.customUrlEditorList.deleteCustomUrlTooltip",
        defaultMessage: "Delete custom URL",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 393,
          columnNumber: 25
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 391,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      color: "danger",
      onClick: () => onDeleteButtonClick(index),
      iconType: "trash",
      "aria-label": _i18n.i18n.translate('xpack.ml.customUrlEditorList.deleteCustomUrlAriaLabel', {
        defaultMessage: 'Delete custom URL'
      }),
      "data-test-subj": `mlJobEditDeleteCustomUrlButton_${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 399,
        columnNumber: 23
      }
    }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 418,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      wrap: true,
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 419,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: styles.narrowField,
      grow: 2,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 420,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.customUrlEditorList.labelLabel",
        defaultMessage: "Label",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 424,
          columnNumber: 19
        }
      }),
      isInvalid: isInvalidLabel,
      error: invalidLabelError,
      "data-test-subj": "mlJobEditCustomUrlItemLabel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 421,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      key: `label-field-${index}`,
      fullWidth: true,
      value: label,
      isInvalid: isInvalidLabel,
      onChange: e => onLabelChange(e, index),
      "data-test-subj": `mlJobEditCustomUrlLabelInput_${index}`,
      "aria-required": "true",
      "aria-label": _i18n.i18n.translate('xpack.ml.customUrlEditorList.labelAriaLabel', {
        defaultMessage: 'Label for custom URL {indexCount}',
        values: {
          indexCount: index + 1
        }
      }),
      "aria-invalid": isInvalidLabel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 433,
        columnNumber: 17
      }
    }))), isCustomTimeRange === false && showTimeRange[index] ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: styles.narrowField,
      grow: 2,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 450,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.customUrlEditorList.timeRangeLabel",
        defaultMessage: "Time range",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 454,
          columnNumber: 21
        }
      }),
      error: invalidIntervalError,
      isInvalid: isInvalidTimeRange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 451,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      value: customUrl.time_range || '',
      isInvalid: isInvalidTimeRange,
      placeholder: _constants.TIME_RANGE_TYPE.AUTO,
      onChange: e => onTimeRangeChange(e, index),
      "aria-label": _i18n.i18n.translate('xpack.ml.customUrlEditorList.timeRangeAriaLabel', {
        defaultMessage: 'Time range for custom URL {indexCount}',
        values: {
          indexCount: index + 1
        }
      }),
      "aria-invalid": isInvalidTimeRange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 462,
        columnNumber: 19
      }
    }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: styles.urlField,
      grow: 6,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 477,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.customUrlEditorList.urlLabel",
        defaultMessage: "URL",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 481,
          columnNumber: 19
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 478,
        columnNumber: 15
      }
    }, index === expandedUrlIndex ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      key: `url-textarea-${index}`,
      inputRef: input => {
        if (input) {
          input.focus();
        }
      },
      fullWidth: true,
      value: customUrl.url_value,
      onChange: e => onUrlValueChange(e, index),
      onBlur: () => {
        setExpandedUrlIndex(null);
      },
      "aria-required": "true",
      "aria-label": _i18n.i18n.translate('xpack.ml.customUrlEditorList.urlValueAriaLabel', {
        defaultMessage: 'URL value for {label}',
        values: {
          label
        }
      }),
      "data-test-subj": `mlJobEditCustomUrlTextarea_${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 488,
        columnNumber: 19
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      key: `url-field-${index}`,
      fullWidth: true,
      value: customUrl.url_value,
      onChange: () => {} // satisfy React's requirement
      ,
      onFocus: () => setExpandedUrlIndex(index),
      "aria-required": "true",
      "aria-label": _i18n.i18n.translate('xpack.ml.customUrlEditorList.urlFieldExpandAriaLabel', {
        defaultMessage: 'URL value for {label}. Click to expand for editing.',
        values: {
          label
        }
      }),
      "data-test-subj": `mlJobEditCustomUrlInput_${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 511,
        columnNumber: 19
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 534,
        columnNumber: 9
      }
    }));
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    role: "list",
    "data-test-subj": "mlJobEditCustomUrlsList",
    "aria-label": _i18n.i18n.translate('xpack.ml.customUrlEditorList.configurationsListAriaLabel', {
      defaultMessage: 'Custom URL configurations'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 540,
      columnNumber: 5
    }
  }, customUrlRows);
};
exports.CustomUrlList = CustomUrlList;