"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadListAndRender = LoadListAndRender;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _maps_list_view = require("./maps_list_view");
var _constants = require("../../../common/constants");
var _content_management = require("../../content_management");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/routes/list_page/load_list_and_render.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function LoadListAndRender(props) {
  const [mapsLoaded, setMapsLoaded] = (0, _react.useState)(false);
  const [hasSavedMaps, setHasSavedMaps] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    props.stateTransfer.clearEditorState(_constants.APP_ID);
    let ignore = false;
    (0, _content_management.getMapClient)().search({
      limit: 1
    }).then(results => {
      if (!ignore) {
        setHasSavedMaps(results.hits.length > 0);
        setMapsLoaded(true);
      }
    }).catch(err => {
      if (!ignore) {
        setMapsLoaded(true);
        setHasSavedMaps(false);
      }
    });
    return () => {
      ignore = true;
    };
    // only run on mount
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  if (!mapsLoaded) {
    // do not render loading state to avoid UI flash when listing page is displayed
    return null;
  }
  return hasSavedMaps ? /*#__PURE__*/_react.default.createElement(_maps_list_view.MapsListView, {
    history: props.history,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 25
    }
  }) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: "/map",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 68
    }
  });
}