"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RENDERER_ID = void 0;
exports.getExpressionRenderer = getExpressionRenderer;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _analytics = require("@kbn/analytics");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _kibana_services = require("../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/lens/choropleth_chart/expression_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RENDERER_ID = exports.RENDERER_ID = 'lens_choropleth_chart_renderer';

/** @internal **/
const extractContainerType = context => {
  if (context) {
    var _recursiveGet;
    const recursiveGet = item => {
      if (item.type) {
        return item;
      } else if (item.child) {
        return recursiveGet(item.child);
      }
    };
    return (_recursiveGet = recursiveGet(context)) === null || _recursiveGet === void 0 ? void 0 : _recursiveGet.type;
  }
};

/** @internal **/
const extractVisualizationType = context => {
  if (context) {
    var _recursiveGet2;
    const recursiveGet = item => {
      if (item.child) {
        return recursiveGet(item.child);
      } else {
        return item;
      }
    };
    return (_recursiveGet2 = recursiveGet(context)) === null || _recursiveGet2 === void 0 ? void 0 : _recursiveGet2.type;
  }
};
function getExpressionRenderer(coreSetup) {
  return {
    name: RENDERER_ID,
    displayName: 'Choropleth chart',
    help: 'Choropleth chart renderer',
    validate: () => undefined,
    reuseDomNode: true,
    render: async (domNode, config, handlers) => {
      const [coreStart, plugins] = await coreSetup.getStartServices();
      const {
        ChoroplethChart
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./choropleth_chart')));
      const {
        getEmsFileLayers
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../util')));
      let emsFileLayers = [];
      try {
        emsFileLayers = await getEmsFileLayers();
      } catch (error) {
        // ignore error, lack of EMS file layers will be surfaced in dimension editor
      }
      const renderComplete = () => {
        const executionContext = handlers.getExecutionContext();
        const containerType = extractContainerType(executionContext);
        const visualizationType = extractVisualizationType(executionContext);
        if (containerType && visualizationType) {
          var _plugins$usageCollect;
          (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, [`render_${visualizationType}_regionmap`]);
        }
        handlers.done();
      };
      const chartSizeEvent = {
        name: 'chartSize',
        data: {
          maxDimensions: {
            x: {
              value: 100,
              unit: 'percentage'
            },
            y: {
              value: 100,
              unit: 'percentage'
            }
          }
        }
      };
      handlers.event(chartSizeEvent);
      _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, (0, _kibana_services.getCore)(), {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(ChoroplethChart, (0, _extends2.default)({}, config, {
        formatFactory: plugins.fieldFormats.deserialize,
        uiSettings: coreStart.uiSettings,
        emsFileLayers: emsFileLayers,
        onRenderComplete: renderComplete,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 11
        }
      }))), domNode);
      handlers.onDestroy(() => _reactDom.default.unmountComponentAtNode(domNode));
    }
  };
}