"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TileMapVisualization = TileMapVisualization;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _rxjs = require("rxjs");
var _map_renderer = require("../../react_embeddable/map_renderer/map_renderer");
var _create_tile_map_layer_descriptor = require("../../classes/layers/create_tile_map_layer_descriptor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/legacy_visualizations/tile_map/tile_map_visualization.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TileMapVisualization(props) {
  const isMounted = (0, _useMountedState.default)();
  const initialMapCenter = (0, _react.useMemo)(() => {
    return {
      lat: props.visConfig.mapCenter[0],
      lon: props.visConfig.mapCenter[1],
      zoom: props.visConfig.mapZoom
    };
    // props.visConfig reference changes each render but values are the same
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const initialLayerList = (0, _react.useMemo)(() => {
    const layerDescriptor = (0, _create_tile_map_layer_descriptor.createTileMapLayerDescriptor)(props.visConfig.layerDescriptorParams);
    return layerDescriptor ? [layerDescriptor] : [];
    // props.visConfig reference changes each render but values are the same
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_map_renderer.MapRenderer, {
    title: props.visConfig.layerDescriptorParams.label,
    filters: props.filters,
    query: props.query,
    timeRange: props.timeRange,
    mapCenter: initialMapCenter,
    isLayerTOCOpen: true,
    layerList: initialLayerList,
    onApiAvailable: api => {
      api.onRenderComplete$.pipe((0, _rxjs.first)()).subscribe(() => {
        if (isMounted()) {
          props.onInitialRenderComplete();
        }
      });
    },
    isSharable: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  });
}