"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorTileAdapter = void 0;
exports.getTileError = getTileError;
exports.getTileMetaFeature = getTileMetaFeature;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _centerOfMass = _interopRequireDefault(require("@turf/center-of-mass"));
var _events = require("events");
var _constants = require("../../../common/constants");
var _geo_tile_utils = require("../../classes/util/geo_tile_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error

class VectorTileAdapter extends _events.EventEmitter {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_layers", {});
    (0, _defineProperty2.default)(this, "_tiles", []);
  }
  addLayer(layerId, label, tileUrl) {
    this._layers[layerId] = {
      label,
      tileUrl
    };
    this._onChange();
  }
  removeLayer(layerId) {
    delete this._layers[layerId];
    this._onChange();
  }
  hasLayers() {
    return Object.keys(this._layers).length > 0;
  }
  setTiles(tiles) {
    this._tiles = tiles;
    this._onChange();
  }
  setTileResults(layerId, tileMetaFeatures, tileErrors) {
    if (!this._layers[layerId]) {
      return;
    }
    this._layers[layerId] = {
      ...this._layers[layerId],
      tileErrors,
      tileMetaFeatures
    };
    this._onChange();
  }
  getLayerOptions() {
    return Object.keys(this._layers).map(layerId => {
      return {
        value: layerId,
        label: this._layers[layerId].label
      };
    });
  }
  getTileRequests(layerId) {
    if (!this._layers[layerId]) {
      return [];
    }
    const {
      tileErrors,
      tileMetaFeatures,
      tileUrl
    } = this._layers[layerId];
    return this._tiles.map(tile => {
      return {
        layerId,
        tileUrl,
        tileError: getTileError(tile.x, tile.y, tile.z, tileErrors),
        tileMetaFeature: getTileMetaFeature(tile.x, tile.y, tile.z, tileMetaFeatures),
        ...tile
      };
    });
  }
  _onChange() {
    this.emit('change');
  }
}
exports.VectorTileAdapter = VectorTileAdapter;
function getTileMetaFeature(x, y, z, tileMetaFeatures) {
  if (!tileMetaFeatures || tileMetaFeatures.length === 0) {
    return;
  }
  return tileMetaFeatures.find(tileMetaFeature => {
    const centerGeometry = (0, _centerOfMass.default)(tileMetaFeature).geometry;
    return (0, _geo_tile_utils.isPointInTile)(centerGeometry.coordinates[_constants.LAT_INDEX], centerGeometry.coordinates[_constants.LON_INDEX], x, y, z);
  });
}
function getTileError(x, y, z, tileErrors) {
  if (!tileErrors || tileErrors.length === 0) {
    return;
  }
  const tileKey = `${z}/${x}/${y}`;
  return tileErrors.find(tileError => {
    return tileError.tileKey === tileKey;
  });
}