"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DecimalDegreesForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/toolbar_overlay/set_view_control/decimal_degrees_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class DecimalDegreesForm extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      lat: this.props.center.lat,
      lon: this.props.center.lon,
      zoom: this.props.zoom
    });
    (0, _defineProperty2.default)(this, "_onLatChange", evt => {
      const sanitizedValue = parseFloat(evt.target.value);
      this.setState({
        lat: isNaN(sanitizedValue) ? '' : sanitizedValue
      });
    });
    (0, _defineProperty2.default)(this, "_onLonChange", evt => {
      const sanitizedValue = parseFloat(evt.target.value);
      this.setState({
        lon: isNaN(sanitizedValue) ? '' : sanitizedValue
      });
    });
    (0, _defineProperty2.default)(this, "_onZoomChange", evt => {
      const sanitizedValue = parseFloat(evt.target.value);
      this.setState({
        zoom: isNaN(sanitizedValue) ? '' : sanitizedValue
      });
    });
    (0, _defineProperty2.default)(this, "_onSubmit", () => {
      const {
        lat,
        lon,
        zoom
      } = this.state;
      this.props.onSubmit(lat, lon, zoom);
    });
  }
  render() {
    const {
      isInvalid: isLatInvalid,
      error: latError
    } = (0, _utils.withinRange)(this.state.lat, -90, 90);
    const {
      isInvalid: isLonInvalid,
      error: lonError
    } = (0, _utils.withinRange)(this.state.lon, -180, 180);
    const {
      isInvalid: isZoomInvalid,
      error: zoomError
    } = (0, _utils.withinRange)(this.state.zoom, this.props.settings.minZoom, this.props.settings.maxZoom);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.setViewControl.latitudeLabel', {
        defaultMessage: 'Latitude'
      }),
      isInvalid: isLatInvalid,
      error: latError,
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      compressed: true,
      value: this.state.lat,
      onChange: this._onLatChange,
      isInvalid: isLatInvalid,
      "data-test-subj": "latitudeInput",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.setViewControl.longitudeLabel', {
        defaultMessage: 'Longitude'
      }),
      isInvalid: isLonInvalid,
      error: lonError,
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      compressed: true,
      value: this.state.lon,
      onChange: this._onLonChange,
      isInvalid: isLonInvalid,
      "data-test-subj": "longitudeInput",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.setViewControl.zoomLabel', {
        defaultMessage: 'Zoom'
      }),
      isInvalid: isZoomInvalid,
      error: zoomError,
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      compressed: true,
      value: this.state.zoom,
      onChange: this._onZoomChange,
      isInvalid: isZoomInvalid,
      "data-test-subj": "zoomInput",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
      textAlign: "right",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      fill: true,
      disabled: isLatInvalid || isLonInvalid || isZoomInvalid,
      onClick: this._onSubmit,
      "data-test-subj": "submitViewButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.setViewControl.submitButtonLabel",
      defaultMessage: "Go",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 13
      }
    }))));
  }
}
exports.DecimalDegreesForm = DecimalDegreesForm;