"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleFieldSelect = SingleFieldSelect;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _reactField = require("@kbn/react-field");
var _calculateWidthFromCharCount = require("@kbn/calculate-width-from-char-count");
var _fieldUtils = require("@kbn/field-utils");
var _constants = require("../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/components/single_field_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function fieldsToOptions(fields, isFieldDisabled, getFieldDisabledReason) {
  if (!fields) {
    return [];
  }
  return fields.map(field => {
    const FieldTypeIcon = field.type ? /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
      type: field.type,
      fill: "none",
      className: "eui-alignMiddle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 9
      }
    }) : null;
    const option = {
      value: field,
      label: field.displayName ? field.displayName : field.name,
      prepend: FieldTypeIcon,
      name: field.name
    };
    if (isFieldDisabled && isFieldDisabled(field)) {
      option.disabled = true;
      const disabledReason = option.disabled && getFieldDisabledReason ? getFieldDisabledReason(option.value) : null;
      if (disabledReason) {
        option.prepend = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, FieldTypeIcon, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          position: "left",
          content: disabledReason,
          anchorProps: {
            css: (0, _react2.css)`
                    position: absolute;
                    width: 100%;
                    top: 0;
                    bottom: 0;
                    left: 0;
                    right: 0;
                  `
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 49,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 63,
            columnNumber: 17
          }
        })));
      }
    }
    return option;
  }).sort((a, b) => {
    return a.label.toLowerCase().localeCompare(b.label.toLowerCase());
  });
}
function SingleFieldSelect({
  fields,
  getFieldDisabledReason,
  isFieldDisabled,
  onChange,
  value,
  ...rest
}) {
  const onSelection = selectedOptions => {
    onChange(_lodash.default.get(selectedOptions, '0.value.name'));
  };
  const selectedOptions = [];
  if (value && fields) {
    const selectedField = fields.find(field => {
      return field.name === value;
    });
    if (selectedField) {
      selectedOptions.push({
        value: selectedField,
        label: selectedField.displayName ? selectedField.displayName : selectedField.name
      });
    }
  }
  const options = fieldsToOptions(fields, isFieldDisabled, getFieldDisabledReason);
  const panelMinWidth = (0, _calculateWidthFromCharCount.calculateWidthFromEntries)(options, ['label']);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    singleSelection: true,
    options: options,
    selectedOptions: selectedOptions,
    onChange: onSelection,
    isDisabled: !fields || fields.length === 0,
    truncationProps: _constants.MIDDLE_TRUNCATION_PROPS,
    inputPopoverProps: {
      panelMinWidth
    },
    optionMatcher: _fieldUtils.comboBoxFieldOptionMatcher
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }));
}