"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricSelect = MetricSelect;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var _es_agg_source = require("../../classes/sources/es_agg_source");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/components/metrics_editor/metric_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AGG_OPTIONS = [{
  label: (0, _es_agg_source.getAggDisplayName)(_constants.AGG_TYPE.AVG),
  value: _constants.AGG_TYPE.AVG
}, {
  label: (0, _es_agg_source.getAggDisplayName)(_constants.AGG_TYPE.COUNT),
  value: _constants.AGG_TYPE.COUNT
}, {
  label: (0, _es_agg_source.getAggDisplayName)(_constants.AGG_TYPE.MAX),
  value: _constants.AGG_TYPE.MAX
}, {
  label: (0, _es_agg_source.getAggDisplayName)(_constants.AGG_TYPE.MIN),
  value: _constants.AGG_TYPE.MIN
}, {
  label: (0, _es_agg_source.getAggDisplayName)(_constants.AGG_TYPE.PERCENTILE),
  value: _constants.AGG_TYPE.PERCENTILE
}, {
  label: (0, _es_agg_source.getAggDisplayName)(_constants.AGG_TYPE.SUM),
  value: _constants.AGG_TYPE.SUM
}, {
  label: (0, _es_agg_source.getAggDisplayName)(_constants.AGG_TYPE.TERMS),
  value: _constants.AGG_TYPE.TERMS
}, {
  label: (0, _es_agg_source.getAggDisplayName)(_constants.AGG_TYPE.UNIQUE_COUNT),
  value: _constants.AGG_TYPE.UNIQUE_COUNT
}];
function MetricSelect({
  value,
  onChange,
  metricsFilter,
  ...rest
}) {
  function onAggChange(selectedOptions) {
    if (selectedOptions.length === 0) {
      return;
    }
    const aggType = selectedOptions[0].value;
    onChange(aggType);
  }
  const options = metricsFilter ? AGG_OPTIONS.filter(metricsFilter) : AGG_OPTIONS;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    placeholder: _i18n.i18n.translate('xpack.maps.metricSelect.selectAggregationPlaceholder', {
      defaultMessage: 'Select aggregation'
    }),
    singleSelection: true,
    isClearable: false,
    options: options,
    selectedOptions: AGG_OPTIONS.filter(option => {
      return value === option.value;
    }),
    onChange: onAggChange
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }));
}