"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.boundsToExtent = boundsToExtent;
var _lodash = require("lodash");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function boundsToExtent(bounds) {
  return {
    minLon: (0, _lodash.round)(bounds.getWest(), _constants.DECIMAL_DEGREES_PRECISION),
    minLat: (0, _lodash.round)(bounds.getSouth(), _constants.DECIMAL_DEGREES_PRECISION),
    maxLon: (0, _lodash.round)(bounds.getEast(), _constants.DECIMAL_DEGREES_PRECISION),
    maxLat: (0, _lodash.round)(bounds.getNorth(), _constants.DECIMAL_DEGREES_PRECISION)
  };
}