"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricSelect = MetricSelect;
exports.OBSERVABILITY_METRIC_TYPE = void 0;
exports.getMetricOptionsForLayer = getMetricOptionsForLayer;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _layer_select = require("./layer_select");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/solution_layers/observability/metric_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let OBSERVABILITY_METRIC_TYPE = exports.OBSERVABILITY_METRIC_TYPE = /*#__PURE__*/function (OBSERVABILITY_METRIC_TYPE) {
  OBSERVABILITY_METRIC_TYPE["TRANSACTION_DURATION"] = "TRANSACTION_DURATION";
  OBSERVABILITY_METRIC_TYPE["COUNT"] = "COUNT";
  OBSERVABILITY_METRIC_TYPE["UNIQUE_COUNT"] = "UNIQUE_COUNT";
  return OBSERVABILITY_METRIC_TYPE;
}({});
const APM_RUM_PERFORMANCE_METRIC_OPTIONS = [{
  value: OBSERVABILITY_METRIC_TYPE.TRANSACTION_DURATION,
  text: _i18n.i18n.translate('xpack.maps.observability.transactionDurationLabel', {
    defaultMessage: 'Transaction duraction'
  })
}];
const APM_RUM_TRAFFIC_METRIC_OPTIONS = [{
  value: OBSERVABILITY_METRIC_TYPE.COUNT,
  text: _i18n.i18n.translate('xpack.maps.observability.countLabel', {
    defaultMessage: 'Count'
  })
}, {
  value: OBSERVABILITY_METRIC_TYPE.UNIQUE_COUNT,
  text: _i18n.i18n.translate('xpack.maps.observability.uniqueCountLabel', {
    defaultMessage: 'Unique count'
  })
}];
function getMetricOptionsForLayer(layer) {
  if (layer === _layer_select.OBSERVABILITY_LAYER_TYPE.APM_RUM_PERFORMANCE) {
    return APM_RUM_PERFORMANCE_METRIC_OPTIONS;
  }
  if (layer === _layer_select.OBSERVABILITY_LAYER_TYPE.APM_RUM_TRAFFIC) {
    return APM_RUM_TRAFFIC_METRIC_OPTIONS;
  }
  return [];
}
function MetricSelect(props) {
  function onChange(event) {
    props.onChange(event.target.value);
  }
  if (!props.layer || !props.value) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.observability.metricLabel', {
      defaultMessage: 'Metric'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: getMetricOptionsForLayer(props.layer),
    value: props.value,
    onChange: onChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }));
}