"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DISPLAY = void 0;
exports.DisplaySelect = DisplaySelect;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/solution_layers/observability/display_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let DISPLAY = exports.DISPLAY = /*#__PURE__*/function (DISPLAY) {
  DISPLAY["CHOROPLETH"] = "CHOROPLETH";
  DISPLAY["CLUSTERS"] = "CLUSTERS";
  DISPLAY["GRIDS"] = "GRIDS";
  DISPLAY["HEATMAP"] = "HEATMAP";
  return DISPLAY;
}({});
const DISPLAY_OPTIONS = [{
  value: DISPLAY.CHOROPLETH,
  text: _i18n.i18n.translate('xpack.maps.observability.choroplethLabel', {
    defaultMessage: 'World boundaries'
  })
}, {
  value: DISPLAY.CLUSTERS,
  text: _i18n.i18n.translate('xpack.maps.observability.clustersLabel', {
    defaultMessage: 'Clusters'
  })
}, {
  value: DISPLAY.GRIDS,
  text: _i18n.i18n.translate('xpack.maps.observability.gridsLabel', {
    defaultMessage: 'Grids'
  })
}, {
  value: DISPLAY.HEATMAP,
  text: _i18n.i18n.translate('xpack.maps.observability.heatMapLabel', {
    defaultMessage: 'Heat map'
  })
}];
function DisplaySelect(props) {
  function onChange(event) {
    props.onChange(event.target.value);
  }
  if (!props.layer) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.observability.displayLabel', {
      defaultMessage: 'Display'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: DISPLAY_OPTIONS,
    value: props.value,
    onChange: onChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }));
}