"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerGroup = exports.DEFAULT_LAYER_GROUP_LABEL = void 0;
exports.isLayerGroup = isLayerGroup;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _i18n = require("@kbn/i18n");
var _std = require("@kbn/std");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _uuid = require("uuid");
var _constants = require("../../../../common/constants");
var _copy_persistent_state = require("../../../reducers/copy_persistent_state");
var _get_layers_extent = require("../../../actions/get_layers_extent");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/layer_group/layer_group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function isLayerGroup(layer) {
  return layer instanceof LayerGroup;
}
const DEFAULT_LAYER_GROUP_LABEL = exports.DEFAULT_LAYER_GROUP_LABEL = _i18n.i18n.translate('xpack.maps.layerGroup.defaultName', {
  defaultMessage: 'Layer group'
});
class LayerGroup {
  static createDescriptor(options) {
    return {
      ...options,
      type: _constants.LAYER_TYPE.LAYER_GROUP,
      id: typeof options.id === 'string' && options.id.length ? options.id : (0, _uuid.v4)(),
      label: typeof options.label === 'string' && options.label.length ? options.label : DEFAULT_LAYER_GROUP_LABEL,
      visible: typeof options.visible === 'boolean' ? options.visible : true
    };
  }
  constructor({
    layerDescriptor
  }) {
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    (0, _defineProperty2.default)(this, "_children", []);
    this._descriptor = LayerGroup.createDescriptor(layerDescriptor);
  }
  setChildren(children) {
    this._children = children;
  }
  getChildren() {
    return [...this._children];
  }
  async _asyncSomeChildren(methodName) {
    const promises = this.getChildren().map(async child => {
      // @ts-ignore
      return child[methodName]();
    });
    return (await Promise.all(promises)).some(result => {
      return result;
    });
  }
  getDescriptor() {
    return this._descriptor;
  }
  async cloneDescriptor() {
    const clonedDescriptor = (0, _copy_persistent_state.copyPersistentState)(this._descriptor);
    clonedDescriptor.id = (0, _uuid.v4)();
    const displayName = await this.getDisplayName();
    clonedDescriptor.label = `Clone of ${displayName}`;
    const childrenDescriptors = await (0, _std.asyncMap)(this.getChildren(), async childLayer => {
      return (await childLayer.cloneDescriptor()).map(childLayerDescriptor => {
        if (childLayerDescriptor.parent === this.getId()) {
          childLayerDescriptor.parent = clonedDescriptor.id;
        }
        return childLayerDescriptor;
      });
    });
    return [..._lodash.default.flatten(childrenDescriptors), clonedDescriptor];
  }
  makeMbLayerId(layerNameSuffix) {
    throw new Error('makeMbLayerId should not be called on LayerGroup, LayerGroup does not render to map');
  }
  isPreviewLayer() {
    return !!this._descriptor.__isPreviewLayer;
  }
  async supportsFitToBounds() {
    return this._asyncSomeChildren('supportsFitToBounds');
  }
  async isFittable() {
    return this._asyncSomeChildren('isFittable');
  }
  isIncludeInFitToBounds() {
    return this.getChildren().some(child => {
      return child.isIncludeInFitToBounds();
    });
  }
  async isFilteredByGlobalTime() {
    return this._asyncSomeChildren('isFilteredByGlobalTime');
  }
  async getDisplayName(source) {
    return this.getLabel();
  }
  async getAttributions() {
    return [];
  }
  getStyleForEditing() {
    throw new Error('getStyleForEditing should not be called on LayerGroup, LayerGroup does not render to map');
  }
  getStyle() {
    throw new Error('getStyle should not be called on LayerGroup, LayerGroup does not render to map');
  }
  getCurrentStyle() {
    throw new Error('getCurrentStyle should not be called on LayerGroup, LayerGroup does not render to map');
  }
  getLabel() {
    return this._descriptor.label ? this._descriptor.label : '';
  }
  getLocale() {
    return null;
  }
  getLayerIcon(isTocIcon) {
    return {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "layers",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 13
        }
      }),
      tooltipContent: ''
    };
  }
  async hasLegendDetails() {
    return this._children.length > 0;
  }
  renderLegendDetails() {
    return null;
  }
  getId() {
    return this._descriptor.id;
  }
  getSource() {
    throw new Error('getSource should not be called on LayerGroup, LayerGroup does not render to map');
  }
  getSourceForEditing() {
    throw new Error('getSourceForEditing should not be called on LayerGroup, LayerGroup does not render to map');
  }
  isVisible() {
    return !!this._descriptor.visible;
  }
  showAtZoomLevel(zoom) {
    return zoom >= this.getMinZoom() && zoom <= this.getMaxZoom();
  }

  /*
   * Returns smallest min from children or MIN_ZOOM when there are no children
   */
  getMinZoom() {
    let min;
    this._children.forEach(child => {
      if (min !== undefined) {
        min = Math.min(min, child.getMinZoom());
      } else {
        min = child.getMinZoom();
      }
    });
    return min !== undefined ? min : _constants.MIN_ZOOM;
  }

  /*
   * Returns largest max from children or MAX_ZOOM when there are no children
   */
  getMaxZoom() {
    let max;
    this._children.forEach(child => {
      if (max !== undefined) {
        max = Math.max(max, child.getMaxZoom());
      } else {
        max = child.getMaxZoom();
      }
    });
    return max !== undefined ? max : _constants.MAX_ZOOM;
  }
  getMinSourceZoom() {
    let min = _constants.MIN_ZOOM;
    this._children.forEach(child => {
      min = Math.max(min, child.getMinSourceZoom());
    });
    return min;
  }
  getMbSourceId() {
    throw new Error('getMbSourceId should not be called on LayerGroup, LayerGroup does not render to map');
  }
  getAlpha() {
    throw new Error('getAlpha should not be called on LayerGroup, LayerGroup does not render to map');
  }
  getQuery() {
    return null;
  }
  renderSourceSettingsEditor(sourceEditorArgs) {
    return null;
  }
  getPrevRequestToken(dataId) {
    return undefined;
  }
  getInFlightRequestTokens() {
    return [];
  }
  getSourceDataRequest() {
    return undefined;
  }
  getDataRequest(id) {
    return undefined;
  }
  isLayerLoading(zoom) {
    if (!this.isVisible()) {
      return false;
    }
    return this._children.some(child => {
      return child.isLayerLoading(zoom);
    });
  }
  hasErrors() {
    return this._children.some(child => {
      return child.hasErrors();
    });
  }
  getErrors() {
    return this.hasErrors() ? [{
      title: _i18n.i18n.translate('xpack.maps.layerGroup.childrenErrorMessage', {
        defaultMessage: `An error occurred when loading nested layers`
      }),
      body: ''
    }] : [];
  }
  hasWarnings() {
    return this._children.some(child => {
      return child.hasWarnings();
    });
  }
  getWarnings() {
    return this.hasWarnings() ? [{
      title: _i18n.i18n.translate('xpack.maps.layerGroup.incompleteResultsWarning', {
        defaultMessage: `Nested layer(s) had issues returning data and results might be incomplete.`
      }),
      body: ''
    }] : [];
  }
  async syncData(syncContext) {
    // layer group does not render to map so there is never sync data request
  }
  getMbLayerIds() {
    return [];
  }
  ownsMbLayerId(layerId) {
    return false;
  }
  ownsMbSourceId(mbSourceId) {
    return false;
  }
  syncLayerWithMB(mbMap) {
    // layer group does not render to map so there is never sync data request
  }
  getLayerTypeIconName() {
    return 'layers';
  }
  async getBounds(getDataRequestContext) {
    return (0, _get_layers_extent.getLayersExtent)(this.getChildren(), getDataRequestContext);
  }
  renderStyleEditor(onStyleDescriptorChange, onCustomIconsChange) {
    return null;
  }
  getIndexPatternIds() {
    return [];
  }
  getQueryableIndexPatternIds() {
    return [];
  }
  syncVisibilityWithMb(mbMap, mbLayerId) {
    throw new Error('syncVisibilityWithMb should not be called on LayerGroup, LayerGroup does not render to map');
  }
  getType() {
    return _constants.LAYER_TYPE.LAYER_GROUP;
  }
  areLabelsOnTop() {
    return false;
  }
  supportsLabelsOnTop() {
    return false;
  }
  supportsLabelLocales() {
    return false;
  }
  async getLicensedFeatures() {
    return [];
  }
  getGeoFieldNames() {
    return [];
  }
  async getStyleMetaDescriptorFromLocalFeatures() {
    throw new Error('getStyleMetaDescriptorFromLocalFeatures should not be called on LayerGroup, LayerGroup does not render to map');
  }
  isBasemap(order) {
    return false;
  }
  getParent() {
    return this._descriptor.parent;
  }
}
exports.LayerGroup = LayerGroup;