"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/logstash/public/application/components/pipeline_list/pipelines_table.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getColumns(openPipeline, clonePipeline) {
  return [{
    field: 'id',
    name: _i18n.i18n.translate('xpack.logstash.pipelinesTable.idColumnLabel', {
      defaultMessage: 'Id'
    }),
    sortable: true,
    render: (id, {
      isCentrallyManaged
    }) => {
      const openPipelineClicked = () => openPipeline(id);
      return isCentrallyManaged ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: openPipelineClicked,
        "data-test-subj": "cellId",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 23,
          columnNumber: 11
        }
      }, id) : /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 27,
          columnNumber: 11
        }
      }, id, " \xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _constants.PIPELINE_LIST.PIPELINE_NOT_CENTRALLY_MANAGED_TOOLTIP_TEXT,
        type: "question",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 29,
          columnNumber: 13
        }
      }));
    }
  }, {
    field: 'description',
    name: _i18n.i18n.translate('xpack.logstash.pipelinesTable.descriptionColumnLabel', {
      defaultMessage: 'Description'
    }),
    render: description => /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "cellDescription",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 32
      }
    }, description),
    sortable: true,
    truncateText: true
  }, {
    field: 'lastModifiedHumanized',
    name: _i18n.i18n.translate('xpack.logstash.pipelinesTable.lastModifiedColumnLabel', {
      defaultMessage: 'Last modified'
    }),
    render: lastModified => /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "cellLastModified",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 33
      }
    }, lastModified),
    sortable: ({
      lastModified
    }) => lastModified.valueOf()
  }, {
    field: 'username',
    name: _i18n.i18n.translate('xpack.logstash.pipelinesTable.modifiedByColumnLabel', {
      defaultMessage: 'Modified by'
    }),
    render: username => /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "cellUsername",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 29
      }
    }, username),
    sortable: true
  }, {
    field: 'id',
    name: '',
    render: (id, {
      isCentrallyManaged
    }) => {
      const cloneClicked = () => {
        clonePipeline(id);
      };
      return isCentrallyManaged ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": `lnkPipelineClone-${id}`,
        iconType: "copy",
        onClick: cloneClicked,
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logstash.pipelinesTable.cloneButtonLabel",
        defaultMessage: "Clone",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 13
        }
      })) : null;
    },
    sortable: false,
    width: '100px'
  }];
}
function PipelinesTableUi({
  clonePipeline,
  createPipeline,
  isReadOnly,
  isSelectable,
  message,
  onDeleteSelectedPipelines,
  onSelectionChange,
  openPipeline,
  pipelines,
  selection,
  pageIndex,
  intl
}) {
  const pagination = {
    pageIndex,
    initialPageSize: _constants.PIPELINE_LIST.INITIAL_PAGE_SIZE,
    totalItemCount: pipelines.length,
    pageSizeOptions: _constants.PIPELINE_LIST.PAGE_SIZE_OPTIONS
  };
  const selectableMessage = (selectable, {
    id
  }) => selectable ? intl.formatMessage({
    id: 'xpack.logstash.pipelinesTable.selectablePipelineMessage',
    defaultMessage: `Select pipeline "{id}"`
  }, {
    id
  }) : _constants.PIPELINE_LIST.PIPELINE_NOT_CENTRALLY_MANAGED_TOOLTIP_TEXT;
  const selectionOptions = isSelectable ? {
    selectable: ({
      isCentrallyManaged
    }) => isCentrallyManaged,
    selectableMessage,
    onSelectionChange
  } : null;

  // display when > 0 selected and user has write permission
  const deleteButton = selection.length && !isReadOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    key: "btnDeletePipelines",
    color: "danger",
    onClick: onDeleteSelectedPipelines,
    "data-test-subj": "btnDeletePipeline",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.logstash.pipelinesTable.deleteButtonLabel",
    defaultMessage: "Delete",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  })) : null;
  const search = {
    box: {
      incremental: true,
      'data-test-subj': 'filter'
    },
    filters: [{
      type: 'field_value_selection',
      field: 'id',
      name: _i18n.i18n.translate('xpack.logstash.pipelinesTable.filterByIdLabel', {
        defaultMessage: 'Filter by ID'
      }),
      multiSelect: false,
      options: pipelines.map(({
        id
      }) => {
        return {
          value: id,
          name: id,
          view: id
        };
      })
    }],
    toolsLeft: deleteButton,
    toolsRight: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: isReadOnly,
      key: "btnAdd",
      fill: true,
      onClick: createPipeline,
      "data-test-subj": "btnAdd",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.pipelinesTable.createPipelineButtonLabel",
      defaultMessage: "Create pipeline",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 9
      }
    }))
  };
  const columns = getColumns(openPipeline, clonePipeline);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    columns: columns,
    "data-test-subj": "pipelineTable",
    itemId: "id",
    items: pipelines,
    message: message,
    pagination: pagination,
    search: search,
    selection: selectionOptions,
    sorting: true,
    rowProps: {
      'data-test-subj': 'row'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 5
    }
  });
}
const PipelinesTable = exports.PipelinesTable = (0, _i18nReact.injectI18n)(PipelinesTableUi);