"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = require("prop-types");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _tooltips = require("../../../../common/constants/tooltips");
var _codeEditor = require("@kbn/code-editor");
var _eui = require("@elastic/eui");
var _confirm_delete_pipeline_modal = require("./confirm_delete_pipeline_modal");
var _flex_item_setting = require("./flex_item_setting");
var _form_label_with_icon_tip = require("./form_label_with_icon_tip");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/logstash/public/application/components/pipeline_editor/pipeline_editor.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class PipelineEditorUi extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "componentDidMount", () => {
      const {
        licenseService: {
          isReadOnly,
          message
        },
        toastNotifications
      } = this.props;
      if (isReadOnly) {
        toastNotifications.addWarning(message);
      }
    });
    (0, _defineProperty2.default)(this, "hideConfirmDeleteModal", () => {
      this.setState({
        showConfirmDeleteModal: false
      });
    });
    (0, _defineProperty2.default)(this, "showConfirmDeleteModal", () => {
      this.setState({
        showConfirmDeleteModal: true
      });
    });
    (0, _defineProperty2.default)(this, "onPipelineIdChange", ({
      target: {
        value
      }
    }) => {
      const pipelineIdErrors = [];
      if (!value) {
        pipelineIdErrors.push(_constants.PIPELINE_EDITOR.ID_REQUIRED_ERR_MSG);
      }
      if (!this.state.pipelineIdPattern.test(value)) {
        pipelineIdErrors.push(_constants.PIPELINE_EDITOR.ID_FORMAT_ERR_MSG);
      }
      this.setState({
        pipelineIdErrors,
        showPipelineIdError: !!pipelineIdErrors.length,
        pipeline: {
          ...this.state.pipeline,
          id: value
        }
      });
    });
    (0, _defineProperty2.default)(this, "isSaveDisabled", () => {
      return this.state.showPipelineIdError || (0, _lodash.isEmpty)(this.state.pipeline.id);
    });
    (0, _defineProperty2.default)(this, "onClose", async () => {
      await this.props.close();
    });
    (0, _defineProperty2.default)(this, "open", async () => {
      const {
        id
      } = this.state.pipeline;
      if (id) {
        await this.props.open(id);
      }
    });
    (0, _defineProperty2.default)(this, "onPipelineSave", () => {
      const {
        pipelineService,
        toastNotifications,
        intl
      } = this.props;
      const {
        id,
        ...pipelineToStore
      } = this.state.pipeline;
      return pipelineService.savePipeline({
        id,
        upstreamJSON: pipelineToStore
      }).then(() => {
        toastNotifications.addSuccess(intl.formatMessage({
          id: 'xpack.logstash.pipelineEditor.pipelineSuccessfullySavedMessage',
          defaultMessage: 'Saved "{id}"'
        }, {
          id
        }));
        this.onClose();
      }).catch(this.notifyOnError);
    });
    (0, _defineProperty2.default)(this, "onPipelineDescriptionChange", ({
      target: {
        value
      }
    }) => {
      this.setState({
        pipeline: {
          ...this.state.pipeline,
          description: value
        }
      });
    });
    (0, _defineProperty2.default)(this, "onPipelineChange", e => {
      this.setState({
        pipeline: {
          ...this.state.pipeline,
          pipeline: e
        }
      });
    });
    (0, _defineProperty2.default)(this, "handleNumberChange", (settingName, value) => {
      const numberValue = parseInt(value, 10);
      this.handleSettingChange(settingName, isNaN(numberValue) ? value : numberValue);
    });
    (0, _defineProperty2.default)(this, "handleMaxByteNumberChange", value => {
      this.setState({
        maxBytesNumber: parseInt(value, 10)
      });
      this.handleSettingChange('queue.max_bytes', value + this.state.maxBytesUnit);
    });
    (0, _defineProperty2.default)(this, "handleMaxByteUnitChange", value => {
      this.setState({
        maxBytesUnit: value
      });
      this.handleSettingChange('queue.max_bytes', this.state.maxBytesNumber + value);
    });
    (0, _defineProperty2.default)(this, "handleSettingChange", (settingName, value) => {
      const settings = {
        ...this.state.pipeline.settings
      };
      settings[settingName] = value;
      this.setState({
        pipeline: {
          ...this.state.pipeline,
          settings
        }
      });
    });
    (0, _defineProperty2.default)(this, "notifyOnError", err => {
      const {
        licenseService,
        toastNotifications
      } = this.props;
      return licenseService.checkValidity().then(() => {
        toastNotifications.addError(err, {
          title: _i18n.i18n.translate('xpack.logstash.pipelineEditor.errorHandlerToastTitle', {
            defaultMessage: 'Pipeline error'
          })
        });
      });
    });
    (0, _defineProperty2.default)(this, "deletePipeline", () => {
      const {
        pipeline: {
          id
        },
        pipelineService,
        toastNotifications,
        intl
      } = this.props;
      this.hideConfirmDeleteModal();
      return pipelineService.deletePipeline(id).then(() => {
        toastNotifications.addSuccess(intl.formatMessage({
          id: 'xpack.logstash.pipelineEditor.pipelineSuccessfullyDeletedMessage',
          defaultMessage: 'Deleted "{id}"'
        }, {
          id
        }));
        this.onClose();
      }).catch(this.notifyOnError);
    });
    (0, _defineProperty2.default)(this, "getPipelineHeadingText", () => {
      const {
        clone,
        id,
        isNewPipeline,
        intl
      } = this.props;
      if (!!clone && id) {
        return intl.formatMessage({
          id: 'xpack.logstash.pipelineEditor.clonePipelineTitle',
          defaultMessage: 'Clone Pipeline "{id}"'
        }, {
          id
        });
      }
      if (!isNewPipeline) {
        return intl.formatMessage({
          id: 'xpack.logstash.pipelineEditor.editPipelineTitle',
          defaultMessage: 'Edit Pipeline "{id}"'
        }, {
          id: this.state.pipeline.id
        });
      }
      return intl.formatMessage({
        id: 'xpack.logstash.pipelineEditor.createPipelineTitle',
        defaultMessage: 'Create Pipeline'
      });
    });
    const {
      pipeline: {
        id: _id,
        description,
        pipeline,
        settings: _settings
      }
    } = this.props;
    const pipelineWorkersSet = typeof _settings['pipeline.workers'] === 'number';
    const pipelineWorkers = pipelineWorkersSet ? _settings['pipeline.workers'] : 1;
    this.state = {
      maxBytesNumber: _settings['queue.max_bytes.number'],
      maxBytesUnit: _settings['queue.max_bytes.units'],
      pipeline: {
        id: _id,
        description,
        pipeline,
        settings: {
          'pipeline.batch.delay': _settings['pipeline.batch.delay'],
          'pipeline.batch.size': _settings['pipeline.batch.size'],
          'pipeline.workers': pipelineWorkers,
          'queue.checkpoint.writes': _settings['queue.checkpoint.writes'],
          'queue.max_bytes': _settings['queue.max_bytes.number'] + _settings['queue.max_bytes.units'],
          'queue.type': _settings['queue.type']
        }
      },
      pipelineIdErrors: [],
      pipelineIdPattern: /^[A-Za-z\_][A-Za-z0-9\-\_]*$/,
      showConfirmDeleteModal: false,
      showPipelineIdError: false
    };
  }
  render() {
    const {
      intl
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      style: {
        width: '100%'
      },
      restrictWidth: true,
      "data-test-subj": `pipelineEdit pipelineEdit-${this.state.pipeline.id}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      pageTitle: this.getPipelineHeadingText(),
      bottomBorder: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 275,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      isInvalid: this.state.showPipelineIdError,
      error: this.state.pipelineIdErrors,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 9
      }
    }, this.props.isNewPipeline && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logstash.pipelineEditor.pipelineIdFormRowLabel",
        defaultMessage: "Pipeline ID",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 281,
          columnNumber: 17
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      "data-test-subj": "inputId",
      isInvalid: this.state.showPipelineIdError,
      name: "pipelineId",
      onBlur: this.onPipelineIdChange,
      onChange: this.onPipelineIdChange,
      value: this.state.pipeline.id || '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logstash.pipelineEditor.descriptionFormRowLabel",
        defaultMessage: "Description",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 301,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "inputDescription",
      fullWidth: true,
      name: "pipelineDescription",
      onChange: this.onPipelineDescriptionChange,
      value: this.state.pipeline.description || '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logstash.pipelineEditor.pipelineFormRowLabel",
        defaultMessage: "Pipeline",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 318,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 315,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "pipelineField",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 324,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
      languageId: "text",
      value: this.state.pipeline.pipeline,
      height: 500,
      options: {
        lineNumbers: 'on',
        tabSize: 2,
        automaticLayout: true
      },
      "aria-label": _i18n.i18n.translate('xpack.logstash.pipelineEditor.pipelineEditorField', {
        defaultMessage: 'Pipeline editor'
      }),
      onChange: this.onPipelineChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 325,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_form_label_with_icon_tip.FormLabelWithIconTip, {
        formRowLabelText: intl.formatMessage({
          id: 'xpack.logstash.pipelineEditor.pipelineWorkersFormRowLabel',
          defaultMessage: 'Pipeline workers'
        }),
        formRowTooltipText: _tooltips.TOOLTIPS.settings['pipeline.workers'],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 343,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 341,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      "data-test-subj": "inputWorkers",
      onChange: e => this.handleNumberChange('pipeline.workers', e.target.value),
      value: this.state.pipeline.settings['pipeline.workers'],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 352,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 358,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 359,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_flex_item_setting.FlexItemSetting, {
      formRowLabelText: intl.formatMessage({
        id: 'xpack.logstash.pipelineEditor.pipelineBatchSizeFormRowLabel',
        defaultMessage: 'Pipeline batch size'
      }),
      formRowTooltipText: _tooltips.TOOLTIPS.settings['pipeline.batch.size'],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 360,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      "data-test-subj": "inputBatchSize",
      onChange: e => this.handleNumberChange('pipeline.batch.size', e.target.value),
      value: this.state.pipeline.settings['pipeline.batch.size'],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 367,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_flex_item_setting.FlexItemSetting, {
      formRowLabelText: intl.formatMessage({
        id: 'xpack.logstash.pipelineEditor.pipelineBatchDelayFormRowLabel',
        defaultMessage: 'Pipeline batch delay'
      }),
      formRowTooltipText: _tooltips.TOOLTIPS.settings['pipeline.batch.delay'],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 373,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      "data-test-subj": "inputBatchDelay",
      onChange: e => this.handleNumberChange('pipeline.batch.delay', e.target.value),
      value: this.state.pipeline.settings['pipeline.batch.delay'],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 380,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 387,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_flex_item_setting.FlexItemSetting, {
      formRowLabelText: intl.formatMessage({
        id: 'xpack.logstash.pipelineEditor.queueTypeFormRowLabel',
        defaultMessage: 'Queue type'
      }),
      formRowTooltipText: _tooltips.TOOLTIPS.settings['queue.type'],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 388,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": "selectQueueType",
      onChange: e => this.handleSettingChange('queue.type', e.target.value),
      options: _constants.PIPELINE_EDITOR.QUEUE_TYPES,
      value: this.state.pipeline.settings['queue.type'],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 395,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_flex_item_setting.FlexItemSetting, {
      formRowLabelText: intl.formatMessage({
        id: 'xpack.logstash.pipelineEditor.queueMaxBytesFormRowLabel',
        defaultMessage: 'Queue max bytes'
      }),
      formRowTooltipText: _tooltips.TOOLTIPS.settings['queue.max_bytes'],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 402,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      "data-test-subj": "inputQueueMaxBytesNumber",
      onChange: e => this.handleMaxByteNumberChange(e.target.value),
      value: this.state.maxBytesNumber,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 409,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_flex_item_setting.FlexItemSetting, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 415,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": "selectQueueMaxBytesUnits",
      onChange: e => this.handleMaxByteUnitChange(e.target.value),
      options: _constants.PIPELINE_EDITOR.UNITS,
      value: this.state.maxBytesUnit,
      "aria-label": _i18n.i18n.translate('xpack.logstash.pipelineEditor.queueMaxBytesUnitsAriaLabel', {
        defaultMessage: 'Queue max bytes units'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 416,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_flex_item_setting.FlexItemSetting, {
      formRowLabelText: intl.formatMessage({
        id: 'xpack.logstash.pipelineEditor.queueCheckpointWritesFormRowLabel',
        defaultMessage: 'Queue checkpoint writes'
      }),
      formRowTooltipText: _tooltips.TOOLTIPS.settings['queue.checkpoint.writes'],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 429,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      "data-test-subj": "inputQueueCheckpointWrites",
      onChange: e => this.handleNumberChange('queue.checkpoint.writes', e.target.value),
      value: this.state.pipeline.settings['queue.checkpoint.writes'],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 436,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 444,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 445,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 446,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "btnSavePipeline",
      fill: true,
      isDisabled: this.isSaveDisabled(),
      onClick: this.onPipelineSave,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 447,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.pipelineEditor.createAndDeployButtonLabel",
      defaultMessage: "Create and deploy",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 453,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 459,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "btnCancel",
      onClick: this.onClose,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 460,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.pipelineEditor.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 461,
        columnNumber: 15
      }
    }))), !this.props.isNewPipeline && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 468,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "danger",
      "data-test-subj": "btnDeletePipeline",
      onClick: this.showConfirmDeleteModal,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 469,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.logstash.pipelineEditor.deletePipelineButtonLabel",
      defaultMessage: "Delete pipeline",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 474,
        columnNumber: 17
      }
    })))), this.state.showConfirmDeleteModal && /*#__PURE__*/_react.default.createElement(_confirm_delete_pipeline_modal.ConfirmDeletePipelineModal, {
      id: this.props.pipeline.id,
      cancelDeleteModal: this.hideConfirmDeleteModal,
      confirmDeletePipeline: this.deletePipeline,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 483,
        columnNumber: 11
      }
    }));
  }
}
PipelineEditorUi.propTypes = {
  id: _propTypes.PropTypes.string,
  clone: _propTypes.PropTypes.bool.isRequired,
  close: _propTypes.PropTypes.func.isRequired,
  isNewPipeline: _propTypes.PropTypes.bool.isRequired,
  licenseService: _propTypes.PropTypes.shape({
    checkValidity: _propTypes.PropTypes.func.isRequired,
    isReadOnly: _propTypes.PropTypes.bool.isRequired,
    message: _propTypes.PropTypes.string
  }).isRequired,
  open: _propTypes.PropTypes.func.isRequired,
  pipeline: _propTypes.PropTypes.shape({
    id: _propTypes.PropTypes.string,
    description: _propTypes.PropTypes.string,
    pipeline: _propTypes.PropTypes.any,
    settings: _propTypes.PropTypes.shape({
      'pipeline.batch.delay': _propTypes.PropTypes.number.isRequired,
      'pipeline.batch.size': _propTypes.PropTypes.number.isRequired,
      'pipeline.workers': _propTypes.PropTypes.number,
      'queue.checkpoint.writes': _propTypes.PropTypes.number.isRequired,
      'queue.max_bytes': _propTypes.PropTypes.number,
      'queue.type': _propTypes.PropTypes.string.isRequired
    })
  }).isRequired,
  pipelineService: _propTypes.PropTypes.shape({
    deletePipeline: _propTypes.PropTypes.func.isRequired,
    savePipeline: _propTypes.PropTypes.func.isRequired
  }).isRequired,
  toastNotifications: _propTypes.PropTypes.shape({
    addWarning: _propTypes.PropTypes.func.isRequired,
    addSuccess: _propTypes.PropTypes.func.isRequired,
    addError: _propTypes.PropTypes.func.isRequired
  }).isRequired
};
const PipelineEditor = exports.PipelineEditor = (0, _i18nReact.injectI18n)(PipelineEditorUi);