"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActiveDataFromDatatable = getActiveDataFromDatatable;
exports.mergeToNewDoc = mergeToNewDoc;
var _common = require("@kbn/data-views-plugin/common");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This piece of logic is shared between the main editor code base and the inline editor one within the embeddable
function mergeToNewDoc(persistedDoc, visualization, datasourceStates, query, filters, activeDatasourceId, adHocDataViews, {
  datasourceMap,
  visualizationMap,
  extractFilterReferences
}) {
  const activeVisualization = visualization.state && visualization.activeId ? visualizationMap[visualization.activeId] : null;
  const activeDatasource = datasourceStates && activeDatasourceId && !datasourceStates[activeDatasourceId].isLoading ? datasourceMap[activeDatasourceId] : undefined;
  if (!activeDatasource || !activeVisualization) {
    return;
  }
  const activeDatasources = Object.keys(datasourceStates).reduce((acc, datasourceId) => ({
    ...acc,
    [datasourceId]: datasourceMap[datasourceId]
  }), {});
  const persistibleDatasourceStates = {};
  const references = [];
  const internalReferences = [];
  Object.entries(activeDatasources).forEach(([id, datasource]) => {
    const {
      state: persistableState,
      references: persistableReferences
    } = datasource.getPersistableState(datasourceStates[id].state);
    persistibleDatasourceStates[id] = persistableState;
    persistableReferences.forEach(r => {
      if (r.type === _constants.INDEX_PATTERN_TYPE && adHocDataViews[r.id]) {
        internalReferences.push(r);
      } else {
        references.push(r);
      }
    });
  });
  let persistibleVisualizationState = visualization.state;
  if (activeVisualization.getPersistableState) {
    const {
      state: persistableState,
      references: persistableReferences
    } = activeVisualization.getPersistableState(visualization.state, activeDatasource, datasourceStates[activeDatasource.id]);
    persistibleVisualizationState = persistableState;
    persistableReferences.forEach(r => {
      if (r.type === _constants.INDEX_PATTERN_TYPE && adHocDataViews[r.id]) {
        internalReferences.push(r);
      } else {
        references.push(r);
      }
    });
  }
  const persistableAdHocDataViews = Object.fromEntries(Object.entries(adHocDataViews).map(([id, dataView]) => {
    const {
      references: dataViewReferences,
      state
    } = _common.DataViewPersistableStateService.extract(dataView);
    references.push(...dataViewReferences);
    return [id, state];
  }));
  const adHocFilters = filters.filter(f => !references.some(r => r.type === _constants.INDEX_PATTERN_TYPE && r.id === f.meta.index)).map(f => ({
    ...f,
    meta: {
      ...f.meta,
      value: undefined
    }
  }));
  const referencedFilters = filters.filter(f => references.some(r => r.type === _constants.INDEX_PATTERN_TYPE && r.id === f.meta.index));
  const {
    state: persistableFilters,
    references: filterReferences
  } = extractFilterReferences(referencedFilters);
  references.push(...filterReferences);
  return {
    savedObjectId: persistedDoc === null || persistedDoc === void 0 ? void 0 : persistedDoc.savedObjectId,
    title: (persistedDoc === null || persistedDoc === void 0 ? void 0 : persistedDoc.title) || '',
    description: persistedDoc === null || persistedDoc === void 0 ? void 0 : persistedDoc.description,
    visualizationType: visualization.activeId,
    type: _constants.DOC_TYPE,
    references,
    state: {
      visualization: persistibleVisualizationState,
      query,
      filters: [...persistableFilters, ...adHocFilters],
      datasourceStates: persistibleDatasourceStates,
      internalReferences,
      adHocDataViews: persistableAdHocDataViews
    },
    version: _constants.LENS_ITEM_LATEST_VERSION
  };
}
function getActiveDataFromDatatable(defaultLayerId, tables = {}) {
  return Object.entries(tables).reduce((acc, [key, value], _index, {
    length
  }) => {
    const id = length === 1 ? defaultLayerId : key;
    acc[id] = value;
    return acc;
  }, {});
}