"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.axisExtentConfigToExpression = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: import it from the expression config directly?
const CHART_TO_FN_NAME = {
  xy: 'axisExtentConfig'
};
const axisExtentConfigToExpression = (extent, chartType = 'xy') => ({
  type: 'expression',
  chain: [{
    type: 'function',
    function: CHART_TO_FN_NAME[chartType],
    arguments: {
      // rely on expression default value here
      mode: extent !== null && extent !== void 0 && extent.mode ? [extent.mode] : [],
      lowerBound: (extent === null || extent === void 0 ? void 0 : extent.lowerBound) != null ? [extent.lowerBound] : [],
      upperBound: (extent === null || extent === void 0 ? void 0 : extent.upperBound) != null ? [extent.upperBound] : [],
      // be explicit in this case
      niceValues: (extent === null || extent === void 0 ? void 0 : extent.niceValues) != null ? [extent.niceValues] : [true]
    }
  }]
});
exports.axisExtentConfigToExpression = axisExtentConfigToExpression;