"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildUserMessagesHelpers = buildUserMessagesHelpers;
var _get_application_user_messages = require("../../app_plugin/get_application_user_messages");
var _utils = require("../../state_management/utils");
var _utils2 = require("../../utils");
var _checks = require("./checks");
var _logger = require("../logger");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getUpdatedState(getVisualizationContext, visualizationMap, datasourceMap) {
  const {
    activeAttributes,
    mergedSearchContext,
    indexPatterns,
    indexPatternRefs,
    activeVisualizationState,
    activeDatasourceState,
    activeData
  } = getVisualizationContext();
  const activeVisualizationId = (0, _utils2.getActiveVisualizationIdFromDoc)(activeAttributes);
  const activeDatasourceId = (0, _utils2.getActiveDatasourceIdFromDoc)(activeAttributes);
  const activeDatasource = activeDatasourceId ? datasourceMap[activeDatasourceId] : null;
  const activeVisualization = activeVisualizationId ? visualizationMap[activeVisualizationId] : undefined;
  const dataViewObject = (0, _utils2.getInitialDataViewsObject)(indexPatterns, indexPatternRefs);
  return {
    activeAttributes,
    mergedSearchContext,
    activeDatasource,
    activeVisualization,
    activeVisualizationId,
    dataViewObject,
    activeVisualizationState,
    activeDatasourceState,
    activeDatasourceId,
    activeData
  };
}
function getWarningMessages({
  activeDatasource,
  activeDatasourceId,
  activeDatasourceState
}, adapters, data) {
  if (!activeDatasource || !activeDatasourceId || !(adapters !== null && adapters !== void 0 && adapters.requests)) {
    return [];
  }
  const requestWarnings = (0, _utils2.getSearchWarningMessages)(adapters.requests, activeDatasource, activeDatasourceState, {
    searchService: data.search
  });
  return requestWarnings;
}
function buildUserMessagesHelpers(api, internalApi, {
  coreStart,
  data,
  visualizationMap,
  datasourceMap,
  spaces
}, onBeforeBadgesRender, metaInfo) {
  let runtimeUserMessages = {};
  const addUserMessages = messages => {
    if (messages.length) {
      (0, _logger.addLog)(`addUserMessages: "${messages.map(({
        uniqueId
      }) => uniqueId).join('", "')}"`);
    }
    for (const message of messages) {
      runtimeUserMessages[message.uniqueId] = message;
    }
  };
  const resetMessages = () => {
    runtimeUserMessages = {};
    internalApi.resetAllMessages();
  };
  const getUserMessages = (locationId, filters) => {
    var _mergedSearchContext$, _mergedSearchContext$2, _mergedSearchContext$3, _mergedSearchContext$4, _mergedSearchContext$5, _mergedSearchContext$6, _mergedSearchContext$7, _mergedSearchContext$8, _mergedSearchContext$9, _activeDatasource$get, _activeVisualization$, _activeVisualization$2, _activeVisualization$3;
    const {
      activeAttributes,
      activeVisualizationState,
      activeVisualization,
      activeVisualizationId,
      activeDatasource,
      activeDatasourceState,
      activeDatasourceId,
      dataViewObject,
      mergedSearchContext,
      activeData
    } = getUpdatedState(internalApi.getVisualizationContext, visualizationMap, datasourceMap);
    const userMessages = [];
    userMessages.push(...(0, _get_application_user_messages.getApplicationUserMessages)({
      visualizationType: activeAttributes === null || activeAttributes === void 0 ? void 0 : activeAttributes.visualizationType,
      visualizationState: {
        state: activeVisualizationState,
        activeId: activeVisualizationId
      },
      visualization: activeVisualization,
      activeDatasource,
      activeDatasourceState: {
        isLoading: !activeDatasourceState,
        state: activeDatasourceState
      },
      dataViews: dataViewObject,
      core: coreStart
    }));
    if (!activeAttributes || !activeDatasourceState || !activeVisualizationState) {
      return userMessages;
    }
    const framePublicAPI = {
      dataViews: dataViewObject,
      datasourceLayers: (0, _utils.getDatasourceLayers)({
        [activeDatasourceId]: {
          isLoading: !activeDatasourceState,
          state: activeDatasourceState
        }
      }, datasourceMap, dataViewObject.indexPatterns),
      query: activeAttributes.state.query,
      filters: (_mergedSearchContext$ = mergedSearchContext.filters) !== null && _mergedSearchContext$ !== void 0 ? _mergedSearchContext$ : [],
      dateRange: {
        fromDate: (_mergedSearchContext$2 = (_mergedSearchContext$3 = mergedSearchContext.timeRange) === null || _mergedSearchContext$3 === void 0 ? void 0 : _mergedSearchContext$3.from) !== null && _mergedSearchContext$2 !== void 0 ? _mergedSearchContext$2 : '',
        toDate: (_mergedSearchContext$4 = (_mergedSearchContext$5 = mergedSearchContext.timeRange) === null || _mergedSearchContext$5 === void 0 ? void 0 : _mergedSearchContext$5.to) !== null && _mergedSearchContext$4 !== void 0 ? _mergedSearchContext$4 : ''
      },
      absDateRange: {
        fromDate: (_mergedSearchContext$6 = (_mergedSearchContext$7 = mergedSearchContext.timeRange) === null || _mergedSearchContext$7 === void 0 ? void 0 : _mergedSearchContext$7.from) !== null && _mergedSearchContext$6 !== void 0 ? _mergedSearchContext$6 : '',
        toDate: (_mergedSearchContext$8 = (_mergedSearchContext$9 = mergedSearchContext.timeRange) === null || _mergedSearchContext$9 === void 0 ? void 0 : _mergedSearchContext$9.to) !== null && _mergedSearchContext$8 !== void 0 ? _mergedSearchContext$8 : ''
      },
      activeData
    };
    if ((0, _checks.hasLegacyURLConflict)(metaInfo, spaces)) {
      userMessages.push((0, _checks.getLegacyURLConflictsMessage)(metaInfo, spaces));
    }
    userMessages.push(...((_activeDatasource$get = activeDatasource === null || activeDatasource === void 0 ? void 0 : activeDatasource.getUserMessages(activeDatasourceState, {
      // limit the fixAction within the embeddable for now
      setState: undefined,
      frame: framePublicAPI,
      visualizationInfo: activeVisualization === null || activeVisualization === void 0 ? void 0 : (_activeVisualization$ = activeVisualization.getVisualizationInfo) === null || _activeVisualization$ === void 0 ? void 0 : _activeVisualization$.call(activeVisualization, activeVisualizationState, framePublicAPI)
    })) !== null && _activeDatasource$get !== void 0 ? _activeDatasource$get : []), ...((_activeVisualization$2 = activeVisualization === null || activeVisualization === void 0 ? void 0 : (_activeVisualization$3 = activeVisualization.getUserMessages) === null || _activeVisualization$3 === void 0 ? void 0 : _activeVisualization$3.call(activeVisualization, activeVisualizationState, {
      frame: framePublicAPI
    })) !== null && _activeVisualization$2 !== void 0 ? _activeVisualization$2 : []));
    return (0, _get_application_user_messages.handleMessageOverwriteFromConsumer)((0, _get_application_user_messages.filterAndSortUserMessages)(userMessages.concat(Object.values(runtimeUserMessages)), locationId, filters !== null && filters !== void 0 ? filters : {}), onBeforeBadgesRender);
  };
  return {
    addUserMessages,
    resetMessages,
    getUserMessages,
    /**
     * Here pass all the messages that comes directly from the Lens validation/info system
     * who includes:
     * * configuration errors (i.e. missing fields)
     * * warning messages (badge related)
     * * info messages (badge related)
     */
    updateMessages: messages => {
      // update the messages only if something changed
      const existingMessages = new Set(internalApi.messages$.getValue().map(({
        uniqueId
      }) => uniqueId));
      if (existingMessages.size !== messages.length || messages.some(({
        uniqueId
      }) => !existingMessages.has(uniqueId))) {
        internalApi.updateMessages(messages);
      }
    },
    updateValidationErrors: messages => {
      (0, _logger.addLog)(`Validation error: ${messages.length ? messages.map(({
        uniqueId
      }) => uniqueId).join(', ') : 'No errors'}`);
      internalApi.updateValidationMessages(messages);
    },
    /**
     * This type of errors are those who need to be rendered in the embeddable native error panel
     * like runtime errors.
     */
    updateBlockingErrors: blockingMessages => {
      var _internalApi$blocking;
      const error = blockingMessages instanceof Error ? blockingMessages : blockingMessages.length ? new Error(typeof blockingMessages[0].longMessage === 'string' && blockingMessages[0].longMessage ? blockingMessages[0].longMessage : blockingMessages[0].shortMessage) : undefined;
      if (error) {
        (0, _logger.addLog)(`Blocking error: ${error === null || error === void 0 ? void 0 : error.message}`);
      }
      if ((error === null || error === void 0 ? void 0 : error.message) !== ((_internalApi$blocking = internalApi.blockingError$.getValue()) === null || _internalApi$blocking === void 0 ? void 0 : _internalApi$blocking.message)) {
        const finalError = (error === null || error === void 0 ? void 0 : error.message) === '' ? undefined : error;
        internalApi.updateBlockingError(finalError);
      }
    },
    updateWarnings: () => {
      addUserMessages(getWarningMessages(getUpdatedState(internalApi.getVisualizationContext, visualizationMap, datasourceMap), api.adapters$.getValue(), data));
    }
  };
}