"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReducedSamplingSectionEntries = ReducedSamplingSectionEntries;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _info_badge = require("../../shared_components/info_badges/info_badge");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/info_badges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ReducedSamplingSectionEntries({
  layers,
  visualizationInfo,
  dataViews
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, layers.map(([id, layer], layerIndex) => {
    const dataView = dataViews.indexPatterns[layer.indexPatternId];
    const layerInfo = visualizationInfo.layers.find(({
      layerId,
      label
    }) => layerId === id);
    const layerTitle = (layerInfo === null || layerInfo === void 0 ? void 0 : layerInfo.label) || _i18n.i18n.translate('xpack.lens.indexPattern.samplingPerLayer.fallbackLayerName', {
      defaultMessage: 'Data layer'
    });
    const layerPalette = layerInfo === null || layerInfo === void 0 ? void 0 : layerInfo.palette;
    return /*#__PURE__*/_react.default.createElement(_info_badge.InfoBadge, {
      title: layerTitle,
      index: layerIndex,
      dataView: dataView.id,
      palette: layerPalette,
      "data-test-subj-prefix": "lns-feature-badges-reducedSampling",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 13
      }
    }, `${Number((0, _utils.getSamplingValue)(layer)) * 100}%`));
  }));
}