"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigBuilderStub = void 0;
exports.isNewApiFormat = isNewApiFormat;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isNewApiFormat(config) {
  var _state;
  return config === null || config === void 0 ? void 0 : (_state = config.state) === null || _state === void 0 ? void 0 : _state.isNewApiFormat;
}
const ConfigBuilderStub = exports.ConfigBuilderStub = {
  /**
   * @returns Lens item
   */
  in(config) {
    const {
      isNewApiFormat: _,
      ...cleanedState
    } = config.state;
    return {
      ...config,
      state: cleanedState
    };
  },
  /**
   * @returns Lens API config
   */
  out(item) {
    return {
      ...item,
      state: {
        ...item.state,
        isNewApiFormat: true
      }
    };
  }
};