"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormRow = FormRow;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/input_control_vis/public/components/vis/form_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function FormRow(props) {
  let control = props.children;
  if (props.disableMsg) {
    control = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: props.disableMsg,
      anchorClassName: "eui-displayBlock",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 7
      }
    }, control);
  }
  const label = props.warningMsg ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: props.warningMsg,
    type: "warning",
    position: "top",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }), props.label) : props.label;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    id: props.id,
    "data-test-subj": 'inputControl' + props.controlIndex,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, control);
}