"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initCreateInventoryViewRoute = void 0;
var _boom = require("@hapi/boom");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _latest = require("../../../common/http_api/latest");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initCreateInventoryViewRoute = ({
  framework,
  getStartServices
}) => {
  framework.registerRoute({
    method: 'post',
    path: _latest.INVENTORY_VIEW_URL,
    validate: {
      body: (0, _ioTsUtils.createRouteValidationFunction)(_latest.createInventoryViewRequestPayloadRT),
      query: (0, _ioTsUtils.createRouteValidationFunction)(_latest.inventoryViewRequestQueryRT)
    }
  }, async (_requestContext, request, response) => {
    const {
      body,
      query
    } = request;
    const [,, {
      inventoryViews
    }] = await getStartServices();
    const inventoryViewsClient = inventoryViews.getScopedClient(request);
    try {
      const inventoryView = await inventoryViewsClient.update(null, body.attributes, query);
      return response.custom({
        statusCode: 201,
        body: _latest.inventoryViewResponsePayloadRT.encode({
          data: inventoryView
        })
      });
    } catch (error) {
      var _error$statusCode, _error$message;
      if ((0, _boom.isBoom)(error)) {
        return response.customError({
          statusCode: error.output.statusCode,
          body: {
            message: error.output.payload.message
          }
        });
      }
      return response.customError({
        statusCode: (_error$statusCode = error.statusCode) !== null && _error$statusCode !== void 0 ? _error$statusCode : 500,
        body: {
          message: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : 'An unexpected error occurred'
        }
      });
    }
  });
};
exports.initCreateInventoryViewRoute = initCreateInventoryViewRoute;