"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AwsRDSLayout = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _chart_section_vis = require("../chart_section_vis");
var _section = require("../section");
var _sub_section = require("../sub_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metric_detail/components/layouts/aws_rds_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AwsRDSLayout = exports.AwsRDSLayout = (0, _eui.withEuiTheme)(({
  metrics,
  onChangeRangeTime,
  theme
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 18,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_section.Section, {
  navLabel: "AWS RDS",
  sectionLabel: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.overviewSection.sectionLabel', {
    defaultMessage: 'Aws RDS Overview'
  }),
  metrics: metrics,
  onChangeRangeTime: onChangeRangeTime,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 19,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsRDSCpuTotal",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.cpuTotal.sectionLabel', {
    defaultMessage: 'Total CPU Usage'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "area",
  formatter: "percent",
  seriesOverrides: {
    cpu: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.cpuTotal.chartLabel', {
        defaultMessage: 'Total'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsRDSConnections",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.connections.sectionLabel', {
    defaultMessage: 'Connections'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 53,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "number",
  seriesOverrides: {
    connections: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.connections.chartLabel', {
        defaultMessage: 'Connections'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsRDSQueriesExecuted",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.queriesExecuted.sectionLabel', {
    defaultMessage: 'Queries Executed'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "number",
  seriesOverrides: {
    queries: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.queriesExecuted.chartLabel', {
        defaultMessage: 'Queries'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 85,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsRDSActiveTransactions",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.activeTransactions.sectionLabel', {
    defaultMessage: 'Transactions'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 99,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "number",
  seriesOverrides: {
    active: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.active.chartLabel', {
        defaultMessage: 'Active'
      })
    },
    blocked: {
      color: theme.euiTheme.colors.vis.euiColorVis2,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.blocked.chartLabel', {
        defaultMessage: 'Blocked'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 108,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsRDSLatency",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.latency.sectionLabel', {
    defaultMessage: 'Latency'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 129,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  stacked: true,
  formatter: "highPrecision",
  formatterTemplate: '{{value}} ms',
  seriesOverrides: {
    read: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.latency.read.chartLabel', {
        defaultMessage: 'Read'
      })
    },
    write: {
      color: theme.euiTheme.colors.vis.euiColorVis2,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.latency.write.chartLabel', {
        defaultMessage: 'Write'
      })
    },
    insert: {
      color: theme.euiTheme.colors.vis.euiColorVis0,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.latency.insert.chartLabel', {
        defaultMessage: 'Insert'
      })
    },
    update: {
      color: theme.euiTheme.colors.vis.euiColorVis7,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.latency.update.chartLabel', {
        defaultMessage: 'Update'
      })
    },
    commit: {
      color: theme.euiTheme.colors.vis.euiColorVis3,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.rdsMetricsLayout.latency.commit.chartLabel', {
        defaultMessage: 'Commit'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 138,
    columnNumber: 11
  }
})))));