"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartSectionVis = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _use_timeline_chart_theme = require("../../../../hooks/use_timeline_chart_theme");
var _series_chart = require("./series_chart");
var _helpers = require("./helpers");
var _error_message = require("./error_message");
var _use_kibana_ui_setting = require("../../../../hooks/use_kibana_ui_setting");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metric_detail/components/chart_section_vis.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ChartSectionVis = ({
  id,
  onChangeRangeTime,
  metric,
  stopLiveStreaming,
  isLiveStreaming,
  formatter,
  formatterTemplate,
  stacked,
  seriesOverrides,
  type
}) => {
  const chartTheme = (0, _use_timeline_chart_theme.useTimelineChartTheme)();
  const [dateFormat] = (0, _use_kibana_ui_setting.useKibanaUiSetting)('dateFormat');
  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const valueFormatter = (0, _react.useCallback)((0, _helpers.getFormatter)(formatter, formatterTemplate), [formatter, formatterTemplate]);
  const dateFormatter = (0, _react.useMemo)(() => metric != null ? (0, _charts.niceTimeFormatter)((0, _helpers.getMaxMinTimestamp)(metric)) : undefined, [metric]);
  const handleTimeChange = (0, _react.useCallback)(({
    x
  }) => {
    if (!x) {
      return;
    }
    const [from, to] = x;
    if (onChangeRangeTime) {
      if (isLiveStreaming && stopLiveStreaming) {
        stopLiveStreaming();
      }
      onChangeRangeTime({
        from: (0, _moment.default)(from).toISOString(),
        to: (0, _moment.default)(to).toISOString(),
        interval: '>=1m'
      });
    }
  }, [onChangeRangeTime, isLiveStreaming, stopLiveStreaming]);
  const tooltipProps = {
    headerFormatter: (0, _react.useCallback)(({
      value
    }) => (0, _moment.default)(value).format(dateFormat || 'Y-MM-DD HH:mm:ss.SSS'), [dateFormat])
  };
  if (!id) {
    return null;
  } else if (!metric) {
    return /*#__PURE__*/_react.default.createElement(_error_message.ErrorMessage, {
      title: _i18n.i18n.translate('xpack.infra.chartSection.missingMetricDataText', {
        defaultMessage: 'Missing Data'
      }),
      body: _i18n.i18n.translate('xpack.infra.chartSection.missingMetricDataBody', {
        defaultMessage: 'The data for this chart is missing.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 7
      }
    });
  } else if (metric.series.some(_helpers.seriesHasLessThen2DataPoints)) {
    return /*#__PURE__*/_react.default.createElement(_error_message.ErrorMessage, {
      title: _i18n.i18n.translate('xpack.infra.chartSection.notEnoughDataPointsToRenderTitle', {
        defaultMessage: 'Not Enough Data'
      }),
      body: _i18n.i18n.translate('xpack.infra.chartSection.notEnoughDataPointsToRenderText', {
        defaultMessage: 'Not enough data points to render chart, try increasing the time range.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "infrastructureChart",
    style: {
      height: 250,
      marginBottom: 16
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "timestamp",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: dateFormatter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "values",
    position: _charts.Position.Left,
    tickFormat: valueFormatter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }), metric && metric.series.map(series => /*#__PURE__*/_react.default.createElement(_series_chart.SeriesChart, {
    key: `series-${id}-${series.id}`,
    id: `series-${id}-${series.id}`,
    series: series,
    name: (0, _helpers.getChartName)(seriesOverrides, series.id, series.id),
    type: (0, _helpers.getChartType)(seriesOverrides, type, series.id),
    color: (0, _helpers.getChartColor)(seriesOverrides, series.id),
    stack: stacked,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, (0, _extends2.default)({}, tooltipProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    onBrushEnd: handleTimeChange,
    baseTheme: chartTheme.baseTheme,
    showLegend: true,
    legendValues: [_charts.LegendValue.CurrentAndLastValue],
    legendPosition: "right",
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }))));
};
exports.ChartSectionVis = ChartSectionVis;