"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DropdownButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _kubernetes_tour = require("./kubernetes_tour");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/dropdown_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ButtonLabel = ({
  label,
  theme
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  css: {
    padding: 7,
    background: theme === null || theme === void 0 ? void 0 : theme.colors.backgroundBaseFormsPrepend,
    borderRight: theme === null || theme === void 0 ? void 0 : theme.border.thin
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("strong", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 7
  }
}, label)));
const DropdownButton = exports.DropdownButton = (0, _eui.withEuiTheme)(props => {
  const {
    onClick,
    label,
    theme,
    children,
    showKubernetesInfo
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    css: {
      border: theme === null || theme === void 0 ? void 0 : theme.euiTheme.border.thin,
      borderRadius: theme === null || theme === void 0 ? void 0 : theme.euiTheme.border.radius.medium
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, showKubernetesInfo ? /*#__PURE__*/_react.default.createElement(_kubernetes_tour.KubernetesTour, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ButtonLabel, {
    label: label,
    theme: theme.euiTheme,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(ButtonLabel, {
    label: label,
    theme: theme.euiTheme,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.infra.dropdownButton.button.ariaLabel', {
      defaultMessage: '{label} options',
      values: {
        label
      }
    }),
    "data-test-subj": props['data-test-subj'],
    color: "text",
    iconType: "arrowDown",
    onClick: onClick,
    iconSide: "right",
    size: "xs",
    css: (0, _react2.css)`
            &::before {
              background: none !important;
            }
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, children)));
});