"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibanaContextForPluginProvider = exports.useKibanaContextForPlugin = exports.createLazyComponentWithKibanaContext = exports.createKibanaContextForPlugin = exports.KibanaEnvironmentContext = void 0;
exports.useKibanaEnvironmentContext = useKibanaEnvironmentContext;
exports.useKibanaEnvironmentContextProvider = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/hooks/use_kibana.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createKibanaContextForPlugin = (core, plugins, pluginStart) => (0, _public.createKibanaReactContext)({
  ...core,
  ...plugins,
  ...pluginStart
});
exports.createKibanaContextForPlugin = createKibanaContextForPlugin;
const KibanaEnvironmentContext = exports.KibanaEnvironmentContext = /*#__PURE__*/(0, _react.createContext)({});
const useKibanaContextForPlugin = exports.useKibanaContextForPlugin = _public.useKibana;
const useKibanaContextForPluginProvider = (core, plugins, pluginStart) => {
  const {
    Provider
  } = (0, _react.useMemo)(() => createKibanaContextForPlugin(core, plugins, pluginStart), [core, pluginStart, plugins]);
  return Provider;
};
exports.useKibanaContextForPluginProvider = useKibanaContextForPluginProvider;
const useKibanaEnvironmentContextProvider = kibanaEnvironment => {
  const value = (0, _react.useMemo)(() => ({
    kibanaVersion: kibanaEnvironment === null || kibanaEnvironment === void 0 ? void 0 : kibanaEnvironment.kibanaVersion,
    isCloudEnv: kibanaEnvironment === null || kibanaEnvironment === void 0 ? void 0 : kibanaEnvironment.isCloudEnv,
    isServerlessEnv: kibanaEnvironment === null || kibanaEnvironment === void 0 ? void 0 : kibanaEnvironment.isServerlessEnv
  }), [kibanaEnvironment]);
  const Provider = ({
    kibanaEnv = {},
    children
  }) => {
    const newProvider = /*#__PURE__*/(0, _react.createElement)(KibanaEnvironmentContext.Provider, {
      value: {
        ...kibanaEnv,
        ...value
      },
      children
    });
    return newProvider;
  };
  return Provider;
};
exports.useKibanaEnvironmentContextProvider = useKibanaEnvironmentContextProvider;
function useKibanaEnvironmentContext() {
  return (0, _react.useContext)(KibanaEnvironmentContext);
}
const createLazyComponentWithKibanaContext = (coreSetup, lazyComponentFactory) => /*#__PURE__*/_react.default.lazy(() => Promise.all([lazyComponentFactory(), coreSetup.getStartServices()]).then(([{
  default: LazilyLoadedComponent
}, [core, plugins, pluginStart]]) => {
  const {
    Provider
  } = createKibanaContextForPlugin(core, plugins, pluginStart);
  return {
    default: props => /*#__PURE__*/_react.default.createElement(Provider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(LazilyLoadedComponent, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 15
      }
    })))
  };
}));
exports.createLazyComponentWithKibanaContext = createLazyComponentWithKibanaContext;