"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RegularExpressionRepresentation = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_results/category_expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RegularExpressionRepresentation = exports.RegularExpressionRepresentation = /*#__PURE__*/(0, _react.memo)(({
  maximumSegmentCount = 30,
  regularExpression
}) => {
  const segments = regularExpression.split(collapsedRegularExpressionCharacters);
  return /*#__PURE__*/_react.default.createElement(CategoryPattern, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  }, segments.slice(0, maximumSegmentCount).map((segment, segmentIndex) => [segmentIndex > 0 ? /*#__PURE__*/_react.default.createElement(CategoryPatternWildcard, {
    key: `wildcard-${segmentIndex}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 13
    }
  }, "\u2055") : null, /*#__PURE__*/_react.default.createElement(CategoryPatternSegment, {
    key: `segment-${segmentIndex}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 11
    }
  }, segment.replace(escapedRegularExpressionCharacters, '$1'))]), segments.length > maximumSegmentCount ? /*#__PURE__*/_react.default.createElement(CategoryPatternWildcard, {
    title: _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.truncatedPatternSegmentDescription', {
      defaultMessage: '{extraSegmentCount, plural, one {one more segment} other {# more segments}}',
      values: {
        extraSegmentCount: segments.length - maximumSegmentCount
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 9
    }
  }, "\u2026") : null);
});
const CategoryPattern = _styled.default.span`
  font-family: ${props => props.theme.euiTheme.font.familyCode};
  word-break: break-all;
`;
const CategoryPatternWildcard = _styled.default.span`
  color: ${props => props.theme.euiTheme.colors.mediumShade};
`;
const CategoryPatternSegment = _styled.default.span`
  font-weight: bold;
`;
const collapsedRegularExpressionCharacters = /\.[+*]\??/g;
const escapedRegularExpressionCharacters = /\\([\\^$*+?.()\[\]])/g;