"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessesEmptyMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/processes/processes_empty_message.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ProcessesEmptyMessage = ({
  schema,
  clearSearchBar
}) => {
  const isEcsSchema = schema === 'ecs' || schema === null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "search",
    titleSize: "s",
    title: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metrics.nodeDetails.noProcesses",
      defaultMessage: "No processes found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 11
      }
    })),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    }, isEcsSchema ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metrics.nodeDetails.noProcessesBody.ecs",
      defaultMessage: "Try modifying your filter. Only processes that are within the configured {metricbeatDocsLink} will display here.",
      values: {
        metricbeatDocsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "infraProcessesTableTopNByCpuOrMemoryLink",
          href: "https://www.elastic.co/guide/en/beats/metricbeat/current/metricbeat-module-system.html",
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 44,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.infra.metrics.nodeDetails.noProcessesBody.metricbeatDocsLinkText",
          defaultMessage: "top N by CPU or Memory",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 49,
            columnNumber: 21
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metrics.nodeDetails.noProcessesBody.semconv",
      defaultMessage: "Try modifying your filter and ensure that you have configured your {otelDocsLink} correctly to emit process data.",
      values: {
        otelDocsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "infraProcessesTableOtelDocsLink",
          href: "https://ela.st/otel-process-hosts-ui",
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 63,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.infra.metrics.nodeDetails.noProcessesBody.otelDocsLinkText",
          defaultMessage: "OTel Collector",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 68,
            columnNumber: 21
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 13
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraProcessesTableClearFiltersButton",
      onClick: clearSearchBar,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metrics.nodeDetails.noProcessesClearFilters",
      defaultMessage: "Clear filters",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  });
};
exports.ProcessesEmptyMessage = ProcessesEmptyMessage;