"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsClosedContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/overview/alerts/alerts_closed_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertsClosedContent = ({
  activeAlertCount
}) => {
  const shouldRenderAlertsClosedContent = typeof activeAlertCount === 'number';
  if (!shouldRenderAlertsClosedContent) {
    return null;
  }
  if (activeAlertCount > 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: _i18n.i18n.translate('xpack.infra.assetDetails.tooltip.activeAlertsExplanation', {
        defaultMessage: 'Active alerts'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 20,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": "infraAssetDetailsAlertsClosedContentWithAlerts",
      iconType: "warning",
      color: "danger",
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 9
      }
    }, activeAlertCount));
  }
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "infraAssetDetailsAlertsClosedContentNoAlerts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.infra.assetDetails.noActiveAlertsContentClosedSection', {
    defaultMessage: 'No active alerts'
  }));
};
exports.AlertsClosedContent = AlertsClosedContent;