"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextProviders = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_reload_request_time = require("../../hooks/use_reload_request_time");
var _use_asset_details_render_props = require("./hooks/use_asset_details_render_props");
var _use_date_picker = require("./hooks/use_date_picker");
var _use_loading_state = require("./hooks/use_loading_state");
var _use_metadata_state = require("./hooks/use_metadata_state");
var _entity_details_metadata_provider = require("./entity_details_metadata_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/context_providers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RenderWithOptionalSearchSessionProvider = ({
  renderMode,
  children
}) => {
  if (renderMode.mode === 'flyout') {
    // flyout mode requires its own search session so that it doesn't interfere with the main page
    return /*#__PURE__*/_react.default.createElement(_use_reload_request_time.ReloadRequestTimeProvider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 12
      }
    }, children);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
const ContextProviders = ({
  children,
  ...props
}) => {
  const {
    entityId,
    entityName,
    autoRefresh,
    dateRange,
    overrides,
    entityType = 'host',
    renderMode,
    preferredSchema
  } = props;
  return /*#__PURE__*/_react.default.createElement(RenderWithOptionalSearchSessionProvider, {
    renderMode: renderMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_use_date_picker.DatePickerProvider, {
    dateRange: dateRange,
    autoRefresh: autoRefresh,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_use_loading_state.LoadingStateProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_use_metadata_state.MetadataStateProvider, {
    entityId: entityId,
    entityType: entityType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_entity_details_metadata_provider.EntityDetailsTimeRangeMetadataProvider, {
    entityType: entityType,
    entityId: entityId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_use_asset_details_render_props.AssetDetailsRenderPropsProvider, {
    entityId: entityId,
    entityName: entityName,
    entityType: entityType,
    overrides: overrides,
    renderMode: renderMode,
    preferredSchema: preferredSchema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 15
    }
  }, children))))));
};
exports.ContextProviders = ContextProviders;