"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorModel = void 0;
var _connector_config = require("./connector_config");
var _connectors = require("./connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Guesses the model based on the connector type and configuration.
 *
 * Inferred from the type for "legacy" connectors,
 * and from the provider config field for inference connectors.
 */
const getConnectorModel = connector => {
  var _connector$config;
  const defaultModel = (0, _connector_config.getConnectorDefaultModel)(connector);
  if (defaultModel) {
    return defaultModel;
  }
  if (connector.type === _connectors.InferenceConnectorType.OpenAI && (_connector$config = connector.config) !== null && _connector$config !== void 0 && _connector$config.apiUrl) {
    var _connector$config2;
    return getOpenAiModelFromUrl((_connector$config2 = connector.config) === null || _connector$config2 === void 0 ? void 0 : _connector$config2.apiUrl);
  }
};
exports.getConnectorModel = getConnectorModel;
const OPENAI_MODEL_NAMES = ['gpt-4.1-mini', 'gpt-4.1-nano', 'gpt-4.1', 'gpt-4o-mini', 'gpt-4o', 'gpt-4', 'gpt-35-turbo', 'o3-mini', 'o1-mini', 'o1'];
function getOpenAiModelFromUrl(apiUrl) {
  const url = new URL(apiUrl);
  if (url.hostname === 'azure.com' || url.hostname.endsWith('.azure.com')) {
    return OPENAI_MODEL_NAMES.find(modelName => {
      return url.pathname.includes(modelName);
    });
  }
}