"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SectionError = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/section_error.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SectionError = ({
  title,
  error,
  ...rest
}) => {
  const {
    cause: causeRoot,
    // wrapEsError() on the server adds a "cause" array
    message,
    statusText,
    attributes: {
      cause: causeAttributes
    } = {}
  } = error;
  const cause = causeAttributes !== null && causeAttributes !== void 0 ? causeAttributes : causeRoot;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, (0, _extends2.default)({
    announceOnMount: true,
    title: title,
    color: "danger",
    iconType: "warning"
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, message || statusText), cause && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }, cause.map((causeMsg, i) => /*#__PURE__*/_react.default.createElement("li", {
    key: i,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 15
    }
  }, causeMsg)))));
};
exports.SectionError = SectionError;