"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlVcuUsageCostTour = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_state_with_localstorage = require("../../../../../hooks/use_state_with_localstorage");
var _app_context = require("../../../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/ml_vcu_usage_cost_tour.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MlVcuUsageCostTour = ({
  anchorPosition = 'downCenter',
  children
}) => {
  const [isTourVisible, setTourVisible] = (0, _use_state_with_localstorage.useStateWithLocalStorage)('MlVcuUsageCostTourSkipKey', false);
  const {
    docLinks
  } = (0, _app_context.useAppContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.parameters.mlCostTour.title",
      defaultMessage: "Machine learning usage",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 9
      }
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.parameters.mlCostTour.subtitle",
      defaultMessage: "VCU consumption",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }),
    maxWidth: "500px",
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.parameters.mlCostTour.contents",
      values: {
        additionalCostsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "mlVcuUsageAdditionalCostLink",
          target: "_blank",
          href: docLinks.links.observability.elasticServerlessSearchManagedLlmUsageCost,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 52,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.mappingsEditor.parameters.mlCostTour.additionalCosts",
          defaultMessage: "additional costs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 57,
            columnNumber: 21
          }
        })),
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "mlVcuUsageLearnMoreLink",
          target: "_blank",
          href: docLinks.links.cloud.elasticsearchBillingManagingCosts,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 64,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.mappingsEditor.parameters.mlCostTour.learnMore",
          defaultMessage: "Learn more",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 69,
            columnNumber: 21
          }
        }))
      },
      defaultMessage: "Performing inference, NLP tasks, and other ML activities on the Elastic Inference Service (EIS) requires machine learning VCUs that incur {additionalCostsLink}. You can perform these activities on other infrastructures as well. {learnMoreLink}",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 13
      }
    }))),
    isStepOpen: !isTourVisible,
    anchorPosition: anchorPosition,
    step: 1,
    stepsTotal: 1,
    onFinish: () => setTourVisible(true),
    "data-test-subj": "mlVcuUsageCostTour",
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "mlVcuUsageCostTourCloseBtn",
      onClick: () => setTourVisible(true),
      "aria-label": _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.mlCostTour.closeButton.ariaLabel', {
        defaultMessage: 'close the cost tour'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.parameters.mlCostTour.closeButton",
      defaultMessage: "Ok",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    })),
    zIndex: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, children);
};
exports.MlVcuUsageCostTour = MlVcuUsageCostTour;