"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaFieldSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation = require("../../../../../services/documentation");
var _shared_imports = require("../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/configuration_form/meta_field_section/meta_field_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const MetaFieldSection = () => /*#__PURE__*/_react.default.createElement(_shared_imports.FormRow, {
  title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.metaFieldTitle', {
    defaultMessage: '_meta field'
  }),
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.mappingsEditor.metaFieldDescription",
    defaultMessage: "Use the _meta field to store any metadata you want. {docsLink}",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _documentation.documentationService.getMetaFieldLink(),
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 31,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.metaFieldDocumentionLink', {
        defaultMessage: 'Learn more.'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 9
    }
  })),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 20,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(UseField, {
  path: "metaField",
  component: _shared_imports.JsonEditorField,
  componentProps: {
    codeEditorProps: {
      height: '400px',
      'aria-label': _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.metaFieldEditorAriaLabel', {
        defaultMessage: '_meta field data editor'
      }),
      'data-test-subj': 'metaField'
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 5
  }
}));
exports.MetaFieldSection = MetaFieldSection;