"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListActionHandler = void 0;
var _react = _interopRequireDefault(require("react"));
var _policy_list_context = require("../policy_list_context");
var _components = require("../../../components");
var _policy_flyout = require("../policy_flyout");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/policy_list/components/list_action_handler.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ListActionHandler = ({
  deletePolicyCallback
}) => {
  const {
    listAction,
    setListAction
  } = (0, _policy_list_context.usePolicyListContext)();
  if ((listAction === null || listAction === void 0 ? void 0 : listAction.actionType) === 'viewIndexTemplates') {
    var _listAction$selectedP;
    return /*#__PURE__*/_react.default.createElement(_components.IndexTemplatesFlyout, {
      policyName: listAction.selectedPolicy.name,
      indexTemplates: (_listAction$selectedP = listAction.selectedPolicy.indexTemplates) !== null && _listAction$selectedP !== void 0 ? _listAction$selectedP : [],
      close: () => {
        setListAction(null);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 21,
        columnNumber: 7
      }
    });
  }
  if ((listAction === null || listAction === void 0 ? void 0 : listAction.actionType) === 'deletePolicy') {
    return /*#__PURE__*/_react.default.createElement(_.ConfirmDelete, {
      policyToDelete: listAction.selectedPolicy,
      callback: () => {
        deletePolicyCallback();
        setListAction(null);
      },
      onCancel: () => {
        setListAction(null);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 7
      }
    });
  }
  if ((listAction === null || listAction === void 0 ? void 0 : listAction.actionType) === 'addIndexTemplate') {
    return /*#__PURE__*/_react.default.createElement(_.AddPolicyToTemplateConfirmModal, {
      policy: listAction.selectedPolicy,
      onSuccess: indexTemplate => {
        // update the linked index templates of the selected policy
        listAction.selectedPolicy.indexTemplates = [...(listAction.selectedPolicy.indexTemplates || []), indexTemplate];
        setListAction(null);
      },
      onCancel: () => setListAction(null),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 7
      }
    });
  }
  if ((listAction === null || listAction === void 0 ? void 0 : listAction.actionType) === 'viewPolicy') {
    return /*#__PURE__*/_react.default.createElement(_policy_flyout.ViewPolicyFlyout, {
      policy: listAction.selectedPolicy,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 12
      }
    });
  }
  return null;
};
exports.ListActionHandler = ListActionHandler;