"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditWarning = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _edit_policy_context = require("../edit_policy_context");
var _navigation = require("../../../services/navigation");
var _shared_imports = require("../../../../shared_imports");
var _components = require("../../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/edit_warning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditWarning = () => {
  var _policy$_meta;
  const {
    isNewPolicy,
    indices,
    indexTemplates,
    policyName,
    policy
  } = (0, _edit_policy_context.useEditPolicyContext)();
  const {
    services: {
      getUrlForApp
    }
  } = (0, _shared_imports.useKibana)();
  const [isIndexTemplatesFlyoutShown, setIsIndexTemplatesShown] = (0, _react.useState)(false);
  if (isNewPolicy) {
    return null;
  }
  const indicesLink = indices.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "linkedIndicesLink",
    external: true,
    href: (0, _navigation.getIndicesListPath)(policyName !== null && policyName !== void 0 ? policyName : '', getUrlForApp),
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.linkedIndices",
    defaultMessage: "{indicesCount, plural, one {# linked index} other {# linked indices}}",
    values: {
      indicesCount: indices.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  })) : null;
  const indexTemplatesLink = indexTemplates.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "linkedIndexTemplatesLink",
    onClick: () => setIsIndexTemplatesShown(!isIndexTemplatesFlyoutShown),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.linkedIndexTemplates",
    defaultMessage: "{indexTemplatesCount, plural, one {# linked index template} other {# linked index templates}}",
    values: {
      indexTemplatesCount: indexTemplates.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  })) : null;
  const dependenciesLinks = indicesLink ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesLink, indexTemplatesLink ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.andDependenciesLink",
    defaultMessage: " and {indexTemplatesLink}",
    values: {
      indexTemplatesLink
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }) : null) : indexTemplatesLink;
  const isManagedPolicy = policy === null || policy === void 0 ? void 0 : (_policy$_meta = policy._meta) === null || _policy$_meta === void 0 ? void 0 : _policy$_meta.managed;
  const isDeprecatedPolicy = policy === null || policy === void 0 ? void 0 : policy.deprecated;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isIndexTemplatesFlyoutShown && /*#__PURE__*/_react.default.createElement(_components.IndexTemplatesFlyout, {
    policyName: policyName !== null && policyName !== void 0 ? policyName : '',
    indexTemplates: indexTemplates,
    close: () => setIsIndexTemplatesShown(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "editWarning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, isManagedPolicy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicyModal.proceedWithCautionCallOutTitle",
      defaultMessage: "Editing a managed policy can break Kibana",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 17
      }
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "editManagedPolicyCallOut",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicyModal.proceedWithCautionCallOutDescription",
    defaultMessage: "Managed policies are critical for internal operations.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  })), isDeprecatedPolicy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicyModal.deprecatedPolicyTitle",
      defaultMessage: "This policy is deprecated",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 17
      }
    }),
    color: "warning",
    iconType: "warning",
    "data-test-subj": "editPolicyWithDeprecation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicyModal.deprecatedPolicyDescription",
    defaultMessage: "This policy is no longer supported and might be removed in a future release. Instead, use one of the other policies available or create a new one.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.editingExistingPolicyMessage",
    defaultMessage: "You are editing an existing policy.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  })), dependenciesLinks ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.dependenciesMessage",
    defaultMessage: " Any changes you make will affect {dependenciesLinks} that {count, plural, one {is} other {are}} attached to this policy.",
    values: {
      dependenciesLinks,
      count: indices.length + indexTemplates.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.saveAsNewMessage",
    defaultMessage: " Alternatively, you can save these changes in a new policy.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }))));
};
exports.EditWarning = EditWarning;