"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGrokPattern = getGrokPattern;
var _utils = require("../utils");
var _get_review_fields = require("./get_review_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Constructs a Grok pattern string by iterating over an array of NamedToken objects.
 */
function getGrokPattern(nodes) {
  return nodes.reduce((acc, node) => {
    return acc + ((0, _utils.isNamedField)(node) ? `%{${node.component}:${node.id}}` : (0, _get_review_fields.sanitize)(node.pattern));
  }, '');
}