"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentEnrollmentConfirmationStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _confirm_agent_enrollment = require("../confirm_agent_enrollment");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/steps/agent_enrollment_confirmation_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AgentEnrollmentPrePollInstructions = ({
  troubleshootLink
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.confirmIncomingDataWithPreview.prePollingInstructions",
    defaultMessage: "After the agent starts up, the Elastic Stack listens for the agent and confirms the enrollment in Fleet. If you're having trouble connecting, check out the {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        external: true,
        href: troubleshootLink,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 29,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.enrollmentInstructions.troubleshootingLink",
        defaultMessage: "troubleshooting guide",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 30,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 7
    }
  }));
};
const AgentEnrollmentConfirmationStep = ({
  selectedPolicyId,
  troubleshootLink,
  onClickViewAgents,
  agentCount,
  showLoading,
  poll = true,
  isLongEnrollment = false
}) => {
  const isComplete = !!agentCount;
  return {
    title: isComplete ? _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepAgentEnrollmentConfirmationComplete', {
      defaultMessage: 'Agent enrollment confirmed'
    }) : _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepAgentEnrollmentConfirmation', {
      defaultMessage: 'Confirm agent enrollment'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!isComplete || poll ? /*#__PURE__*/_react.default.createElement(_confirm_agent_enrollment.ConfirmAgentEnrollment, {
      policyId: selectedPolicyId,
      troubleshootLink: troubleshootLink,
      onClickViewAgents: onClickViewAgents,
      agentCount: agentCount,
      showLoading: !isComplete || showLoading,
      isLongEnrollment: isLongEnrollment,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(AgentEnrollmentPrePollInstructions, {
      troubleshootLink: troubleshootLink,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    })),
    status: !isComplete ? 'incomplete' : 'complete'
  };
};
exports.AgentEnrollmentConfirmationStep = AgentEnrollmentConfirmationStep;