"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePoliciesPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _constants = require("../../../../../constants");
var _side_bar_column = require("../../../components/side_bar_column");
var _setup_technology = require("../../../../../../fleet/sections/agent_policy/create_package_policy_page/single_page_layout/hooks/setup_technology");
var _use_package_policies_with_agent_policy = require("./use_package_policies_with_agent_policy");
var _agent_based_table = require("./components/agent_based_table");
var _agentless_table = require("./components/agentless_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/policies/package_policies.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PackagePoliciesPage = ({
  packageInfo,
  embedded
}) => {
  var _agentBasedData$total, _agentlessData$total, _agentlessData$total2, _agentBasedData$total2, _agentBasedData$total3;
  const {
    name,
    version,
    type
  } = packageInfo;
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const queryParams = (0, _react.useMemo)(() => new URLSearchParams(search), [search]);
  const addAgentToPolicyIdFromParams = (0, _react.useMemo)(() => queryParams.get('addAgentToPolicyId'), [queryParams]);
  const showAddAgentHelpForPolicyId = (0, _react.useMemo)(() => queryParams.get('showAddAgentHelpForPolicyId'), [queryParams]);
  const {
    getPath
  } = (0, _hooks.useLink)();
  const getPackageInstallStatus = (0, _hooks.useGetPackageInstallStatus)();
  const packageInstallStatus = getPackageInstallStatus(name);
  const {
    isPackagePolicyUpgradable
  } = (0, _hooks.useIsPackagePolicyUpgradable)();
  const {
    isAgentlessIntegration
  } = (0, _setup_technology.useAgentless)();
  const canHaveAgentlessPolicies = (0, _react.useMemo)(() => isAgentlessIntegration(packageInfo), [isAgentlessIntegration, packageInfo]);

  // Helper function to map raw policies data for consumption by the table
  const mapPoliciesData = (0, _react.useCallback)(({
    agentPolicies,
    packagePolicy
  }, index) => {
    return {
      agentPolicies,
      packagePolicy: {
        ...packagePolicy,
        package: {
          ...(packagePolicy === null || packagePolicy === void 0 ? void 0 : packagePolicy.package),
          type
        },
        hasUpgrade: isPackagePolicyUpgradable(packagePolicy)
      },
      rowIndex: index
    };
  }, [isPackagePolicyUpgradable, type]);

  // States and data for agent-based policies table
  // If agentless is not supported or not an agentless integration, skip the
  // conditional in the kuery
  const {
    pagination: agentBasedPagination,
    pageSizeOptions: agentBasedPageSizeOptions,
    setPagination: agentBasedSetPagination
  } = (0, _hooks.usePagination)();
  const [agentBasedPackageAndAgentPolicies, setAgentBasedPackageAndAgentPolicies] = (0, _react.useState)([]);
  const {
    data: agentBasedData,
    isLoading: agentBasedIsLoading,
    resendRequest: refreshAgentBasedPolicies
  } = (0, _use_package_policies_with_agent_policy.usePackagePoliciesWithAgentPolicy)({
    page: agentBasedPagination.currentPage,
    perPage: agentBasedPagination.pageSize,
    kuery: `${_constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name: "${name}" ${canHaveAgentlessPolicies ? `AND NOT ${_constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.supports_agentless: true` : ``}`
  });
  (0, _react.useEffect)(() => {
    const mappedPoliciesData = !(agentBasedData !== null && agentBasedData !== void 0 && agentBasedData.items) ? [] : agentBasedData.items.map(mapPoliciesData);
    setAgentBasedPackageAndAgentPolicies(mappedPoliciesData);
  }, [agentBasedData, mapPoliciesData]);

  // States and data for agentless policies table
  // If agentless is not supported or not an agentless integration, this block and
  // initial request is unnessary but reduces code complexity
  const {
    pagination: agentlessPagination,
    pageSizeOptions: agentlessPageSizeOptions,
    setPagination: agentlessSetPagination
  } = (0, _hooks.usePagination)();
  const [agentlessPackageAndAgentPolicies, setAgentlessPackageAndAgentPolicies] = (0, _react.useState)([]);
  const {
    data: agentlessData,
    isLoading: agentlessIsLoading,
    resendRequest: refreshAgentlessPolicies
  } = (0, _use_package_policies_with_agent_policy.usePackagePoliciesWithAgentPolicy)({
    page: agentlessPagination.currentPage,
    perPage: agentlessPagination.pageSize,
    kuery: `${_constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name: "${name}" AND ${_constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.supports_agentless: true`
  });
  (0, _react.useEffect)(() => {
    setAgentlessPackageAndAgentPolicies(!(agentlessData !== null && agentlessData !== void 0 && agentlessData.items) ? [] : agentlessData.items.map(mapPoliciesData));
  }, [agentlessData, mapPoliciesData]);

  // if they arrive at this page and the package is not installed, send them to overview
  // this happens if they arrive with a direct url or they uninstall while on this tab
  // Check `addAgentToPolicyIdFromParams` otherwise right after installing a new integration the flyout won't open
  if (packageInstallStatus && packageInstallStatus.status !== _types.InstallStatus.installed && !addAgentToPolicyIdFromParams) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: getPath('integration_details_overview', {
        pkgkey: `${name}-${version}`
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_hooks.AgentPolicyRefreshContext.Provider, {
    value: {
      refresh: () => {
        refreshAgentBasedPolicies();
        refreshAgentlessPolicies();
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }, embedded ? null : /*#__PURE__*/_react.default.createElement(_side_bar_column.SideBarColumn, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 28
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 9
    }
  }, !canHaveAgentlessPolicies ? /*#__PURE__*/_react.default.createElement(_agent_based_table.AgentBasedPackagePoliciesTable, {
    isLoading: agentBasedIsLoading,
    packagePolicies: agentBasedPackageAndAgentPolicies,
    packagePoliciesTotal: (_agentBasedData$total = agentBasedData === null || agentBasedData === void 0 ? void 0 : agentBasedData.total) !== null && _agentBasedData$total !== void 0 ? _agentBasedData$total : 0,
    refreshPackagePolicies: refreshAgentBasedPolicies,
    pagination: {
      pagination: agentBasedPagination,
      pageSizeOptions: agentBasedPageSizeOptions,
      setPagination: agentBasedSetPagination
    },
    addAgentToPolicyIdFromParams: addAgentToPolicyIdFromParams,
    showAddAgentHelpForPolicyId: showAddAgentHelpForPolicyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "agentBasedAccordion",
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.integrationList.agentlessHeader",
      defaultMessage: "Agentless",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 27
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: "subdued",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 25
      }
    }, (_agentlessData$total = agentlessData === null || agentlessData === void 0 ? void 0 : agentlessData.total) !== null && _agentlessData$total !== void 0 ? _agentlessData$total : 0)))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_agentless_table.AgentlessPackagePoliciesTable, {
    isLoading: agentlessIsLoading,
    packagePolicies: agentlessPackageAndAgentPolicies,
    packagePoliciesTotal: (_agentlessData$total2 = agentlessData === null || agentlessData === void 0 ? void 0 : agentlessData.total) !== null && _agentlessData$total2 !== void 0 ? _agentlessData$total2 : 0,
    refreshPackagePolicies: refreshAgentlessPolicies,
    pagination: {
      pagination: agentlessPagination,
      pageSizeOptions: agentlessPageSizeOptions,
      setPagination: agentlessSetPagination
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "agentBasedAccordion",
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.integrationList.agentBasedHeader",
      defaultMessage: "Agent-based",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 27
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: "subdued",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 25
      }
    }, (_agentBasedData$total2 = agentBasedData === null || agentBasedData === void 0 ? void 0 : agentBasedData.total) !== null && _agentBasedData$total2 !== void 0 ? _agentBasedData$total2 : 0)))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_based_table.AgentBasedPackagePoliciesTable, {
    isLoading: agentBasedIsLoading,
    packagePolicies: agentBasedPackageAndAgentPolicies,
    packagePoliciesTotal: (_agentBasedData$total3 = agentBasedData === null || agentBasedData === void 0 ? void 0 : agentBasedData.total) !== null && _agentBasedData$total3 !== void 0 ? _agentBasedData$total3 : 0,
    refreshPackagePolicies: refreshAgentBasedPolicies,
    pagination: {
      pagination: agentBasedPagination,
      pageSizeOptions: agentBasedPageSizeOptions,
      setPagination: agentBasedSetPagination
    },
    addAgentToPolicyIdFromParams: addAgentToPolicyIdFromParams,
    showAddAgentHelpForPolicyId: showAddAgentHelpForPolicyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 19
    }
  })))))));
};
exports.PackagePoliciesPage = PackagePoliciesPage;