"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputFormKafkaAuthentication = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _multi_row_input = require("../multi_row_input");
var _constants = require("../../../../../../../common/constants");
var _output_form_secret_form_row = require("./output_form_secret_form_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/edit_output_flyout/output_form_kafka_authentication.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const kafkaSaslOptions = [{
  id: _constants.kafkaSaslMechanism.Plain,
  label: 'Plain',
  'data-test-subj': 'kafkaSaslPlainRadioButton'
}, {
  id: _constants.kafkaSaslMechanism.ScramSha256,
  label: 'SCRAM-SHA-256',
  'data-test-subj': 'kafkaSaslScramSha256RadioButton'
}, {
  id: _constants.kafkaSaslMechanism.ScramSha512,
  label: 'SCRAM-SHA-512',
  'data-test-subj': 'kafkaSaslScramSha512RadioButton'
}];
const kafkaAuthenticationsOptions = [{
  id: _constants.kafkaAuthType.None,
  label: 'None',
  'data-test-subj': 'kafkaAuthenticationNoneRadioButton'
}, {
  id: _constants.kafkaAuthType.Userpass,
  label: 'Username / Password',
  'data-test-subj': 'kafkaAuthenticationUsernamePasswordRadioButton'
}, {
  id: _constants.kafkaAuthType.Ssl,
  label: 'SSL',
  'data-test-subj': 'kafkaAuthenticationSSLRadioButton'
}];
const OutputFormKafkaAuthentication = props => {
  const {
    inputs,
    useSecretsStorage,
    onToggleSecretStorage
  } = props;
  const [isConvertedToSecret, setIsConvertedToSecret] = _react.default.useState({
    kafkaAuthPassword: false,
    kafkaSslKey: false
  });
  const [isFirstLoad, setIsFirstLoad] = _react.default.useState(true);
  (0, _react.useEffect)(() => {
    if (!isFirstLoad) return;
    setIsFirstLoad(false);
    // populate the secret input with the value of the plain input in order to re-save the output with secret storage
    if (useSecretsStorage) {
      if (inputs.kafkaAuthPasswordInput.value && !inputs.kafkaAuthPasswordSecretInput.value) {
        inputs.kafkaAuthPasswordSecretInput.setValue(inputs.kafkaAuthPasswordInput.value);
        inputs.kafkaAuthPasswordInput.clear();
        setIsConvertedToSecret({
          ...isConvertedToSecret,
          kafkaAuthPassword: true
        });
      }
      if (inputs.kafkaSslKeyInput.value && !inputs.kafkaSslKeySecretInput.value) {
        inputs.kafkaSslKeySecretInput.setValue(inputs.kafkaSslKeyInput.value);
        inputs.kafkaSslKeyInput.clear();
        setIsConvertedToSecret({
          ...isConvertedToSecret,
          kafkaSslKey: true
        });
      }
    }
  }, [useSecretsStorage, inputs.kafkaAuthPasswordInput, inputs.kafkaAuthPasswordSecretInput, inputs.kafkaSslKeyInput, inputs.kafkaSslKeySecretInput, isFirstLoad, setIsFirstLoad, isConvertedToSecret]);
  const onToggleSecretAndClearValue = secretEnabled => {
    if (secretEnabled) {
      inputs.kafkaAuthPasswordInput.clear();
      inputs.kafkaSslKeyInput.clear();
    } else {
      inputs.kafkaAuthPasswordSecretInput.setValue('');
      inputs.kafkaSslKeySecretInput.setValue('');
    }
    setIsConvertedToSecret({
      kafkaAuthPassword: false,
      kafkaSslKey: false
    });
    onToggleSecretStorage(secretEnabled);
  };
  const kafkaVerificationModeOptions = (0, _react.useMemo)(() => Object.keys(_constants.kafkaVerificationModes).map(key => {
    return {
      text: _constants.kafkaVerificationModes[key],
      label: key
    };
  }), []);
  const kafkaConnectionTypeOptions = (0, _react.useMemo)(() => Object.keys(_constants.kafkaConnectionType).map(key => {
    return {
      id: _constants.kafkaConnectionType[key],
      label: key,
      'data-test-subj': `kafkaConnectionType${key}RadioButton`
    };
  }), []);
  const renderAuthentication = () => {
    switch (inputs.kafkaAuthMethodInput.value) {
      case _constants.kafkaAuthType.None:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          fullWidth: true,
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.kafkaConnectionTypeLabel",
            defaultMessage: "Connection",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 156,
              columnNumber: 15
            }
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 153,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, (0, _extends2.default)({
          name: "kafkaConnectionType",
          style: {
            display: 'flex',
            gap: 30
          },
          "data-test-subj": 'settingsOutputsFlyout.kafkaConnectionTypeRadioInput',
          options: kafkaConnectionTypeOptions,
          compressed: true
        }, inputs.kafkaConnectionTypeInput.props, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 162,
            columnNumber: 13
          }
        })));
      case _constants.kafkaAuthType.Ssl:
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
          fullWidth: true,
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.sslCertificateInputLabel",
            defaultMessage: "Client SSL certificate",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 178,
              columnNumber: 17
            }
          })
        }, inputs.kafkaSslCertificateInput.formRowProps, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 175,
            columnNumber: 13
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
          fullWidth: true,
          rows: 5
        }, inputs.kafkaSslCertificateInput.props, {
          placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.kafkaSslCertificateInputPlaceholder', {
            defaultMessage: 'Specify ssl certificate'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 185,
            columnNumber: 15
          }
        }))), !useSecretsStorage ? /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
          fullWidth: true,
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.sslKeyInputLabel",
            defaultMessage: "Client SSL certificate key",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 201,
              columnNumber: 19
            }
          })
        }, inputs.kafkaSslKeyInput.formRowProps, {
          useSecretsStorage: useSecretsStorage,
          onToggleSecretStorage: onToggleSecretAndClearValue,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 198,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
          fullWidth: true,
          rows: 5
        }, inputs.kafkaSslKeyInput.props, {
          placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder', {
            defaultMessage: 'Specify certificate key'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 210,
            columnNumber: 17
          }
        }))) : /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
          fullWidth: true,
          title: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.kafkaPasswordSecretInputTitle', {
            defaultMessage: 'Client SSL certificate key'
          })
        }, inputs.kafkaSslKeySecretInput.formRowProps, {
          useSecretsStorage: useSecretsStorage,
          isConvertedToSecret: isConvertedToSecret.kafkaSslKey,
          onToggleSecretStorage: onToggleSecretAndClearValue,
          cancelEdit: inputs.kafkaSslKeySecretInput.cancelEdit,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 223,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
          fullWidth: true,
          rows: 5,
          "data-test-subj": "kafkaSslKeySecretInput"
        }, inputs.kafkaSslKeySecretInput.props, {
          placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder', {
            defaultMessage: 'Specify certificate key'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 237,
            columnNumber: 17
          }
        }))));
      default:
      case _constants.kafkaAuthType.Userpass:
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
          fullWidth: true,
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.kafkaUsernameInputLabel",
            defaultMessage: "Username",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 260,
              columnNumber: 17
            }
          })
        }, inputs.kafkaAuthUsernameInput.formRowProps, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 257,
            columnNumber: 13
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
          "data-test-subj": "settingsOutputsFlyout.kafkaUsernameInput",
          fullWidth: true
        }, inputs.kafkaAuthUsernameInput.props, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 267,
            columnNumber: 15
          }
        }))), !useSecretsStorage ? /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
          fullWidth: true,
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.kafkaPasswordInputLabel",
            defaultMessage: "Password",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 277,
              columnNumber: 19
            }
          })
        }, inputs.kafkaAuthPasswordInput.formRowProps, {
          useSecretsStorage: useSecretsStorage,
          onToggleSecretStorage: onToggleSecretAndClearValue,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 274,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, (0, _extends2.default)({
          type: 'dual',
          "data-test-subj": "settingsOutputsFlyout.kafkaPasswordInput",
          fullWidth: true
        }, inputs.kafkaAuthPasswordInput.props, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 286,
            columnNumber: 17
          }
        }))) : /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
          fullWidth: true,
          title: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.kafkaPasswordInputtitle', {
            defaultMessage: 'Password'
          })
        }, inputs.kafkaAuthPasswordSecretInput.formRowProps, {
          useSecretsStorage: useSecretsStorage,
          isConvertedToSecret: isConvertedToSecret.kafkaAuthPassword,
          onToggleSecretStorage: onToggleSecretAndClearValue,
          cancelEdit: inputs.kafkaAuthPasswordSecretInput.cancelEdit,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 294,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, (0, _extends2.default)({
          type: 'dual',
          "data-test-subj": "settingsOutputsFlyout.kafkaPasswordSecretInput",
          fullWidth: true
        }, inputs.kafkaAuthPasswordSecretInput.props, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 308,
            columnNumber: 17
          }
        }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          fullWidth: true,
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.settings.editOutputFlyout.kafkaSaslInputLabel",
            defaultMessage: "SASL Mechanism",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 319,
              columnNumber: 17
            }
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 316,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, (0, _extends2.default)({
          name: "kafkaSaslMechanism",
          style: {
            display: 'flex',
            gap: 30
          },
          "data-test-subj": 'settingsOutputsFlyout.kafkaSaslInput',
          options: kafkaSaslOptions,
          compressed: true
        }, inputs.kafkaSaslMechanismInput.props, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 325,
            columnNumber: 15
          }
        }))));
    }
  };
  const renderEncryptionSection = () => {
    const displayEncryptionSection = inputs.kafkaConnectionTypeInput.value !== _constants.kafkaConnectionType.Plaintext || inputs.kafkaAuthMethodInput.value !== _constants.kafkaAuthType.None;
    if (!displayEncryptionSection) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 350,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
      placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputPlaceholder', {
        defaultMessage: 'Specify certificate authority'
      }),
      label: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.kafkaSslCertificateAuthoritiesInputLabel', {
        defaultMessage: 'Server SSL certificate authorities (optional)'
      }),
      multiline: true,
      sortable: false
    }, inputs.kafkaSslCertificateAuthoritiesInput.props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 352,
        columnNumber: 9
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.editOutputFlyout.kafkaVerificationModeInputLabel",
        defaultMessage: "Verification mode",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 373,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 370,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
      fullWidth: true,
      "data-test-subj": "settingsOutputsFlyout.kafkaVerificationModeInput"
    }, inputs.kafkaVerificationModeInput.props, {
      options: kafkaVerificationModeOptions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 379,
        columnNumber: 11
      }
    }))));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "m",
    hasShadow: false,
    paddingSize: 'm',
    color: 'subdued',
    "data-test-subj": "settingsOutputsFlyout.kafkaAuthenticationPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "FleetEditOutputFlyoutKafkaAuthenticationTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 400,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.kafkaAuthenticationTitle",
    defaultMessage: "Authentication",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 408,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, (0, _extends2.default)({
    name: "kafkaAuthMethod",
    style: {
      display: 'flex',
      gap: 30
    },
    "data-test-subj": 'settingsOutputsFlyout.kafkaAuthenticationRadioInput',
    options: kafkaAuthenticationsOptions,
    compressed: true
  }, inputs.kafkaAuthMethodInput.props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 409,
      columnNumber: 11
    }
  }))), renderAuthentication()), renderEncryptionSection());
};
exports.OutputFormKafkaAuthentication = OutputFormKafkaAuthentication;