"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAgentPolicy = createAgentPolicy;
exports.updateAgentlessCloudConnectorConfig = exports.createAgentPolicyIfNeeded = void 0;
exports.useOnSubmit = useOnSubmit;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _jsYaml = require("js-yaml");
var _lodash = require("lodash");
var _common = require("@kbn/spaces-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _errors = require("../../../../../../../../common/errors");
var _use_space_settings_context = require("../../../../../../../hooks/use_space_settings_context");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _services = require("../../../../../services");
var _common2 = require("../../../../../../../../common");
var _services2 = require("../../../../../../../../common/services");
var _agentless_policy_helper = require("../../../../../../../../common/services/agentless_policy_helper");
var _hooks2 = require("../../../../../../integrations/hooks");
var _services3 = require("../../services");
var _components = require("../../components");
var _hooks3 = require("../../hooks");
var _prepare_input_pkg_policy_dataset = require("../../services/prepare_input_pkg_policy_dataset");
var _services4 = require("../../../../../../../components/cloud_security_posture/services");
var _ensure_kibana_assets_installed = require("../../../../../services/ensure_kibana_assets_installed");
var _setup_technology = require("./setup_technology");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/single_page_layout/hooks/form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_AGENTLESS_LIMIT = 5;
async function createAgentPolicy({
  packagePolicy,
  newAgentPolicy,
  withSysMonitoring
}) {
  var _packagePolicy$packag;
  // do not create agent policy with system integration if package policy already is for system package
  const packagePolicyIsSystem = (packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name) === _common2.FLEET_SYSTEM_PACKAGE;
  const resp = await (0, _hooks.sendCreateAgentPolicy)(newAgentPolicy, {
    withSysMonitoring: withSysMonitoring && !packagePolicyIsSystem
  });
  if (resp.error) {
    throw resp.error;
  }
  if (!resp.data) {
    throw new Error('Invalid agent policy creation no data');
  }
  return resp.data.item;
}
const createAgentPolicyIfNeeded = async ({
  selectedPolicyTab,
  withSysMonitoring,
  newAgentPolicy,
  packagePolicy,
  packageInfo
}) => {
  if (selectedPolicyTab === _components.SelectedPolicyTab.NEW) {
    var _ref, _newAgentPolicy$monit;
    if ((_ref = withSysMonitoring || ((_newAgentPolicy$monit = newAgentPolicy.monitoring_enabled) === null || _newAgentPolicy$monit === void 0 ? void 0 : _newAgentPolicy$monit.length)) !== null && _ref !== void 0 ? _ref : 0 > 0) {
      var _newAgentPolicy$monit2, _newAgentPolicy$monit3;
      const packagesToPreinstall = [];
      // skip preinstall of input package, to be able to rollback when package policy creation fails
      if (packageInfo && packageInfo.type !== 'input') {
        packagesToPreinstall.push({
          name: packageInfo.name,
          version: packageInfo.version
        });
      }
      if (withSysMonitoring) {
        packagesToPreinstall.push(_common2.FLEET_SYSTEM_PACKAGE);
      }
      if ((_newAgentPolicy$monit2 = (_newAgentPolicy$monit3 = newAgentPolicy.monitoring_enabled) === null || _newAgentPolicy$monit3 === void 0 ? void 0 : _newAgentPolicy$monit3.length) !== null && _newAgentPolicy$monit2 !== void 0 ? _newAgentPolicy$monit2 : 0 > 0) {
        packagesToPreinstall.push(_common2.FLEET_ELASTIC_AGENT_PACKAGE);
      }
      if (packagesToPreinstall.length > 0) {
        await (0, _hooks.sendBulkInstallPackages)([...new Set(packagesToPreinstall)]);
      }
    }
    return await createAgentPolicy({
      newAgentPolicy,
      packagePolicy,
      withSysMonitoring
    });
  }
};
exports.createAgentPolicyIfNeeded = createAgentPolicyIfNeeded;
async function savePackagePolicy(pkgPolicy) {
  const {
    policy,
    forceCreateNeeded
  } = await (0, _prepare_input_pkg_policy_dataset.prepareInputPackagePolicyDataset)(pkgPolicy);
  const result = await (0, _hooks.sendCreatePackagePolicy)({
    ...policy,
    ...(forceCreateNeeded && {
      force: true
    })
  });
  return result;
}
// Update the agentless policy with cloud connector info in the new agent policy when the package policy input `aws.support_cloud_connectors is updated
const updateAgentlessCloudConnectorConfig = (packagePolicy, newAgentPolicy, setNewAgentPolicy, setPackagePolicy) => {
  var _packagePolicy$inputs, _input$type$match, _newAgentPolicy$agent, _newAgentPolicy$agent2, _newAgentPolicy$agent3, _newAgentPolicy$agent4, _newAgentPolicy$agent5;
  const input = (_packagePolicy$inputs = packagePolicy.inputs) === null || _packagePolicy$inputs === void 0 ? void 0 : _packagePolicy$inputs.find(pinput => pinput.enabled === true);
  const targetCsp = input === null || input === void 0 ? void 0 : (_input$type$match = input.type.match(/aws|azure/)) === null || _input$type$match === void 0 ? void 0 : _input$type$match[0];

  // Making sure that the cloud connector is disabled when switching to GCP
  if (!targetCsp && ((_newAgentPolicy$agent = newAgentPolicy.agentless) !== null && _newAgentPolicy$agent !== void 0 && _newAgentPolicy$agent.cloud_connectors || packagePolicy.supports_cloud_connector)) {
    setNewAgentPolicy({
      ...newAgentPolicy,
      agentless: {
        ...newAgentPolicy.agentless,
        cloud_connectors: undefined
      }
    });
    setPackagePolicy({
      ...packagePolicy,
      supports_cloud_connector: false
    });
    return;
  }
  const cloudConnectorPolicyEnabled = !!packagePolicy.supports_cloud_connector;
  const cloudConnectorPolicyMismatch = ((_newAgentPolicy$agent2 = newAgentPolicy.agentless) === null || _newAgentPolicy$agent2 === void 0 ? void 0 : (_newAgentPolicy$agent3 = _newAgentPolicy$agent2.cloud_connectors) === null || _newAgentPolicy$agent3 === void 0 ? void 0 : _newAgentPolicy$agent3.enabled) !== cloudConnectorPolicyEnabled;
  if (targetCsp && newAgentPolicy !== null && newAgentPolicy !== void 0 && newAgentPolicy.supports_agentless && (cloudConnectorPolicyMismatch || ((_newAgentPolicy$agent4 = newAgentPolicy.agentless) === null || _newAgentPolicy$agent4 === void 0 ? void 0 : (_newAgentPolicy$agent5 = _newAgentPolicy$agent4.cloud_connectors) === null || _newAgentPolicy$agent5 === void 0 ? void 0 : _newAgentPolicy$agent5.target_csp) !== targetCsp)) {
    setNewAgentPolicy({
      ...newAgentPolicy,
      agentless: {
        ...newAgentPolicy.agentless,
        cloud_connectors: {
          enabled: cloudConnectorPolicyEnabled,
          target_csp: targetCsp
        }
      }
    });
    setPackagePolicy({
      ...packagePolicy,
      supports_cloud_connector: cloudConnectorPolicyEnabled
    });
  }
};
exports.updateAgentlessCloudConnectorConfig = updateAgentlessCloudConnectorConfig;
const DEFAULT_PACKAGE_POLICY = {
  name: '',
  description: '',
  namespace: '',
  policy_id: '',
  policy_ids: [''],
  enabled: true,
  inputs: []
};
function useOnSubmit({
  agentCount,
  selectedPolicyTab,
  newAgentPolicy,
  withSysMonitoring,
  queryParamsPolicyId,
  packageInfo,
  integrationToEnable,
  hasFleetAddAgentsPrivileges,
  setNewAgentPolicy,
  setSelectedPolicyTab,
  isAddIntegrationFlyout
}) {
  var _packagePolicy$packag3;
  const {
    notifications,
    docLinks
  } = (0, _hooks.useStartServices)();
  const {
    spaceId
  } = (0, _hooks.useFleetStatus)();
  const confirmForceInstall = (0, _hooks2.useConfirmForceInstall)();
  const spaceSettings = (0, _use_space_settings_context.useSpaceSettingsContext)();
  const {
    canUseMultipleAgentPolicies
  } = (0, _hooks.useMultipleAgentPolicies)();

  // only used to store the resulting package policy once saved
  const [savedPackagePolicy, setSavedPackagePolicy] = (0, _react.useState)();
  // Form state
  const [formState, setFormState] = (0, _react.useState)('VALID');

  // Used to render extension components only when package policy is initialized
  const [isInitialized, setIsInitialized] = (0, _react.useState)(false);
  const isFetchingBasePackage = (0, _react.useRef)(false);
  const [agentPolicies, setAgentPolicies] = (0, _react.useState)([]);
  // New package policy state
  const [packagePolicy, setPackagePolicy] = (0, _react.useState)({
    ...DEFAULT_PACKAGE_POLICY
  });
  const [integration, setIntegration] = (0, _react.useState)(integrationToEnable);

  // Validation state
  const [validationResults, setValidationResults] = (0, _react.useState)();
  const [hasAgentPolicyError, setHasAgentPolicyError] = (0, _react.useState)(false);
  const {
    isAgentlessIntegration,
    isAgentlessAgentPolicy
  } = (0, _setup_technology.useAgentless)();
  const hasErrors = validationResults ? (0, _services3.validationHasErrors)(validationResults) : false;

  // Update agent policy method
  const updateAgentPolicies = (0, _react.useCallback)(updatedAgentPolicies => {
    if ((0, _lodash.isEqual)(updatedAgentPolicies, agentPolicies)) {
      return;
    }
    setAgentPolicies(updatedAgentPolicies);
    if (packageInfo) {
      setHasAgentPolicyError(false);
    }
  }, [packageInfo, agentPolicies]);
  // Update package policy validation
  const updatePackagePolicyValidation = (0, _react.useCallback)(newPackagePolicy => {
    if (packageInfo) {
      const newValidationResult = (0, _services3.validatePackagePolicy)(newPackagePolicy || packagePolicy, packageInfo, _jsYaml.load, spaceSettings);
      setValidationResults(newValidationResult);
      return newValidationResult;
    }
  }, [packagePolicy, packageInfo, spaceSettings]);
  // Update package policy method
  const updatePackagePolicy = (0, _react.useCallback)(updatedFields => {
    const newPackagePolicy = {
      ...packagePolicy,
      ...updatedFields
    };
    setPackagePolicy(newPackagePolicy);
    const newValidationResults = updatePackagePolicyValidation(newPackagePolicy);
    const hasPackage = newPackagePolicy.package;
    const hasValidationErrors = newValidationResults ? (0, _services3.validationHasErrors)(newValidationResults) : false;
    const hasAgentPolicy = newPackagePolicy.policy_ids.length > 0 && newPackagePolicy.policy_ids[0] !== '' || selectedPolicyTab === _components.SelectedPolicyTab.NEW;
    const isOrphaningPolicy = canUseMultipleAgentPolicies && newPackagePolicy.policy_ids.length === 0;
    if (hasPackage && (hasAgentPolicy || isOrphaningPolicy) && !hasValidationErrors) {
      setFormState('VALID');
    } else {
      setFormState('INVALID');
    }
  }, [packagePolicy, updatePackagePolicyValidation, selectedPolicyTab, canUseMultipleAgentPolicies]);

  // Initial loading of package info
  (0, _react.useEffect)(() => {
    async function init() {
      var _packagePolicy$packag2;
      if (!packageInfo || packageInfo.name === ((_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.name) && integrationToEnable === integration) {
        return;
      }
      if (integrationToEnable !== integration) {
        setIntegration(integrationToEnable);
      }

      // Fetch all packagePolicies having the package name
      if (!isFetchingBasePackage.current) {
        // Prevent multiple calls to fetch base package
        isFetchingBasePackage.current = true;
        const {
          data: packagePolicyData
        } = await (0, _hooks.sendGetPackagePolicies)({
          perPage: _common2.SO_SEARCH_LIMIT,
          page: 1,
          kuery: `${_common2.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:${packageInfo.name}`
        });
        const incrementedName = (0, _services2.getMaxPackageName)(packageInfo.name, packagePolicyData === null || packagePolicyData === void 0 ? void 0 : packagePolicyData.items);
        const basePackagePolicy = (0, _services.packageToPackagePolicy)(packageInfo, agentPolicies.map(policy => policy.id), '', DEFAULT_PACKAGE_POLICY.name || incrementedName, DEFAULT_PACKAGE_POLICY.description, integrationToEnable);

        // Set the package policy with the fetched package
        updatePackagePolicy(basePackagePolicy);
        setIsInitialized(true);
        isFetchingBasePackage.current = false;
      }
    }
    if (!isInitialized || isAddIntegrationFlyout) {
      // Fetch agent policies
      init();
    }
  }, [isFetchingBasePackage, packageInfo, agentPolicies, updatePackagePolicy, integrationToEnable, isInitialized, (_packagePolicy$packag3 = packagePolicy.package) === null || _packagePolicy$packag3 === void 0 ? void 0 : _packagePolicy$packag3.name, integration, setIntegration, isAddIntegrationFlyout]);
  (0, _react.useEffect)(() => {
    if ((canUseMultipleAgentPolicies || agentPolicies.length > 0) && !(0, _lodash.isEqual)(agentPolicies.map(policy => policy.id), packagePolicy.policy_ids)) {
      updatePackagePolicy({
        policy_ids: agentPolicies.map(policy => policy.id)
      });
    }
  }, [packagePolicy, agentPolicies, updatePackagePolicy, canUseMultipleAgentPolicies]);
  const {
    handleSetupTechnologyChange,
    allowedSetupTechnologies,
    selectedSetupTechnology,
    defaultSetupTechnology
  } = (0, _setup_technology.useSetupTechnology)({
    newAgentPolicy,
    setNewAgentPolicy,
    updatePackagePolicy,
    setSelectedPolicyTab,
    packageInfo,
    packagePolicy,
    integrationToEnable,
    hideAgentlessSelector: isAddIntegrationFlyout
  });
  const setupTechnologyRef = (0, _react.useRef)(selectedSetupTechnology);
  // sync the inputs with the agentless selector change
  (0, _react.useEffect)(() => {
    setupTechnologyRef.current = selectedSetupTechnology;
  });
  const prevSetupTechnology = setupTechnologyRef.current;
  const isAgentlessSelected = isAgentlessIntegration(packageInfo) && selectedSetupTechnology === _types.SetupTechnology.AGENTLESS;
  const newInputs = (0, _react.useMemo)(() => {
    return packagePolicy.inputs.map((input, i) => {
      if ((0, _agentless_policy_helper.isInputAllowedForDeploymentMode)(input, isAgentlessSelected ? 'agentless' : 'default', packageInfo)) {
        return input;
      } else {
        return {
          ...input,
          enabled: false
        };
      }
    });
  }, [packagePolicy.inputs, isAgentlessSelected, packageInfo]);
  (0, _react.useEffect)(() => {
    if (prevSetupTechnology !== selectedSetupTechnology) {
      updatePackagePolicy({
        inputs: newInputs
      });
    }
  }, [newInputs, prevSetupTechnology, selectedSetupTechnology, updatePackagePolicy, packagePolicy]);
  updateAgentlessCloudConnectorConfig(packagePolicy, newAgentPolicy, setNewAgentPolicy, setPackagePolicy);
  const onSaveNavigate = (0, _hooks3.useOnSaveNavigate)({
    queryParamsPolicyId
  });
  const navigateAddAgent = policy => onSaveNavigate(policy, ['openEnrollmentFlyout']);
  const navigateAddAgentHelp = policy => onSaveNavigate(policy, ['showAddAgentHelp']);
  const onSubmit = (0, _react.useCallback)(async ({
    force,
    overrideCreatedAgentPolicy,
    skipConfirmModal
  } = {}) => {
    var _createdPolicy, _createdPolicy2;
    if (formState === 'VALID' && hasErrors) {
      setFormState('INVALID');
      return;
    }
    if ((agentCount !== 0 || agentPolicies.length === 0 && selectedPolicyTab !== _components.SelectedPolicyTab.NEW) && !(isAgentlessIntegration(packageInfo) || isAgentlessAgentPolicy(overrideCreatedAgentPolicy)) && formState !== 'CONFIRM') {
      setFormState('CONFIRM');
      return;
    }
    let createdPolicy = overrideCreatedAgentPolicy;
    if (!overrideCreatedAgentPolicy) {
      try {
        setFormState('LOADING');
        const newPolicy = await createAgentPolicyIfNeeded({
          newAgentPolicy,
          packagePolicy,
          withSysMonitoring,
          packageInfo,
          selectedPolicyTab
        });
        if (newPolicy) {
          createdPolicy = newPolicy;
          setAgentPolicies([createdPolicy]);
          updatePackagePolicy({
            policy_ids: [createdPolicy.id]
          });
        }
      } catch (e) {
        var _e$attributes, _e$attributes3;
        setFormState('VALID');
        const agentlessPolicy = agentPolicies.find(policy => (policy === null || policy === void 0 ? void 0 : policy.supports_agentless) === true);
        if ((e === null || e === void 0 ? void 0 : (_e$attributes = e.attributes) === null || _e$attributes === void 0 ? void 0 : _e$attributes.type) === _errors.AgentlessAgentCreateOverProvisionedError.name) {
          var _e$attributes$limit, _e$attributes2;
          notifications.toasts.addError(e, {
            title: _i18n.i18n.translate('xpack.fleet.createAgentlessPolicy.errorNotificationTitle', {
              defaultMessage: 'Unable to create integration'
            }),
            // @ts-expect-error
            toastMessage: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.fleet.createAgentlessPolicy.overProvisionErrorMessage",
              defaultMessage: "You've reached the maximum number of {limit} agentless deployments. To add more, either remove or change some to Elastic Agent-based integrations. {docLink}",
              values: {
                limit: /*#__PURE__*/_react.default.createElement("b", {
                  __self: this,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 517,
                    columnNumber: 30
                  }
                }, (_e$attributes$limit = e === null || e === void 0 ? void 0 : (_e$attributes2 = e.attributes) === null || _e$attributes2 === void 0 ? void 0 : _e$attributes2.limit) !== null && _e$attributes$limit !== void 0 ? _e$attributes$limit : DEFAULT_AGENTLESS_LIMIT),
                docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
                  href: docLinks.links.fleet.agentlessIntegrations,
                  target: "_blank",
                  __self: this,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 519,
                    columnNumber: 25
                  }
                }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                  id: "xpack.fleet.createAgentlessPolicy.seeDocLink",
                  defaultMessage: "See agentless documentation.",
                  __self: this,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 520,
                    columnNumber: 27
                  }
                }))
              },
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 513,
                columnNumber: 19
              }
            }))
          });
        }
        if ((e === null || e === void 0 ? void 0 : (_e$attributes3 = e.attributes) === null || _e$attributes3 === void 0 ? void 0 : _e$attributes3.type) === _errors.AgentlessAgentCreateFleetUnreachableError.name) {
          var _e$message;
          notifications.toasts.addError(e, {
            title: _i18n.i18n.translate('xpack.fleet.createAgentlessPolicy.errorNotificationTitle', {
              defaultMessage: 'Unable to create integration'
            }),
            // @ts-expect-error
            toastMessage: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.fleet.createAgentlessPolicy.FleetUnreachableErrorMessage",
              defaultMessage: "Fleet is not reachable and required to create agentless policy. Error: {errorMessage}. {docLink}",
              values: {
                errorMessage: (_e$message = e === null || e === void 0 ? void 0 : e.message) !== null && _e$message !== void 0 ? _e$message : '',
                docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
                  href: docLinks.links.fleet.agentlessIntegrations,
                  target: "_blank",
                  __self: this,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 546,
                    columnNumber: 25
                  }
                }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                  id: "xpack.fleet.createAgentlessPolicy.seeDocLink",
                  defaultMessage: "See agentless documentation.",
                  __self: this,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 547,
                    columnNumber: 27
                  }
                }))
              },
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 540,
                columnNumber: 19
              }
            }))
          });
        } else {
          notifications.toasts.addError(e, {
            title: agentlessPolicy !== null && agentlessPolicy !== void 0 && agentlessPolicy.supports_agentless ? _i18n.i18n.translate('xpack.fleet.createAgentlessPolicy.errorNotificationTitle', {
              defaultMessage: 'Unable to create integration'
            }) : _i18n.i18n.translate('xpack.fleet.createAgentPolicy.errorNotificationTitle', {
              defaultMessage: 'Unable to create agent policy'
            })
          });
        }
        return;
      }
    }
    const agentPolicyIdToSave = (_createdPolicy = createdPolicy) !== null && _createdPolicy !== void 0 && _createdPolicy.id ? [(_createdPolicy2 = createdPolicy) === null || _createdPolicy2 === void 0 ? void 0 : _createdPolicy2.id] : packagePolicy.policy_ids;
    const shouldForceInstallOnAgentless = isAgentlessAgentPolicy(createdPolicy) || isAgentlessIntegration(packageInfo);
    const forceInstall = force || shouldForceInstallOnAgentless;
    setFormState('LOADING');
    // passing pkgPolicy with policy_id here as setPackagePolicy doesn't propagate immediately
    const {
      error,
      data
    } = await savePackagePolicy({
      ...packagePolicy,
      policy_ids: agentPolicyIdToSave,
      force: forceInstall
    });
    if (!error && data !== null && data !== void 0 && data.item.package) {
      await (0, _ensure_kibana_assets_installed.ensurePackageKibanaAssetsInstalled)({
        currentSpaceId: spaceId !== null && spaceId !== void 0 ? spaceId : _common.DEFAULT_SPACE_ID,
        pkgName: data.item.package.name,
        pkgVersion: data.item.package.version,
        toasts: notifications.toasts
      });
    }
    const hasAzureArmTemplate = data !== null && data !== void 0 && data.item ? (0, _services4.getAzureArmPropsFromPackagePolicy)(data.item).templateUrl : false;
    const hasCloudFormation = data !== null && data !== void 0 && data.item ? (0, _services4.getCloudFormationPropsFromPackagePolicy)(data.item).templateUrl : false;
    const hasGoogleCloudShell = data !== null && data !== void 0 && data.item ? (0, _services4.getCloudShellUrlFromPackagePolicy)(data.item) : false;

    // Check if agentless is configured in ESS and Serverless until Agentless API migrates to Serverless
    const isAgentlessConfigured = isAgentlessAgentPolicy(createdPolicy);

    // Removing this code will disabled the Save and Continue button. We need code below update form state and trigger correct modal depending on agent count
    if (hasFleetAddAgentsPrivileges && !isAgentlessConfigured && !skipConfirmModal) {
      if (agentCount) {
        setFormState('SUBMITTED');
      } else if (hasAzureArmTemplate) {
        setFormState('SUBMITTED_AZURE_ARM_TEMPLATE');
      } else if (hasCloudFormation) {
        setFormState('SUBMITTED_CLOUD_FORMATION');
      } else if (hasGoogleCloudShell) {
        setFormState('SUBMITTED_GOOGLE_CLOUD_SHELL');
      } else {
        setFormState('SUBMITTED_NO_AGENTS');
      }
    }
    if (!error) {
      setSavedPackagePolicy(data.item);
      const promptForAgentEnrollment = (createdPolicy || agentPolicies.length > 0 && !agentCount) && !isAgentlessConfigured && hasFleetAddAgentsPrivileges;
      if (!skipConfirmModal) {
        if (promptForAgentEnrollment && hasAzureArmTemplate) {
          setFormState('SUBMITTED_AZURE_ARM_TEMPLATE');
          return;
        }
        if (promptForAgentEnrollment && hasCloudFormation) {
          setFormState('SUBMITTED_CLOUD_FORMATION');
          return;
        }
        if (promptForAgentEnrollment && hasGoogleCloudShell) {
          setFormState('SUBMITTED_GOOGLE_CLOUD_SHELL');
          return;
        }
        if (promptForAgentEnrollment) {
          setFormState('SUBMITTED_NO_AGENTS');
          return;
        }
        if (isAgentlessConfigured) {
          onSaveNavigate(data.item, ['openEnrollmentFlyout']);
        } else {
          onSaveNavigate(data.item);
        }
      }
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.fleet.createPackagePolicy.addedNotificationTitle', {
          defaultMessage: `''{packagePolicyName}'' integration added.`,
          values: {
            packagePolicyName: packagePolicy.name
          }
        }),
        text: promptForAgentEnrollment ? _i18n.i18n.translate('xpack.fleet.createPackagePolicy.addedNotificationMessage', {
          defaultMessage: `Fleet will deploy updates to all agents that use the ''{agentPolicyNames}'' policies.`,
          values: {
            agentPolicyNames: agentPolicies.map(policy => policy.name).join(', ')
          }
        }) : undefined,
        'data-test-subj': 'packagePolicyCreateSuccessToast'
      });
    } else {
      if ((0, _services.isVerificationError)(error)) {
        setFormState('VALID'); // don't show the add agent modal
        const forceInstallUnverifiedIntegration = await confirmForceInstall(packagePolicy.package);
        if (forceInstallUnverifiedIntegration) {
          // skip creating the agent policy because it will have already been successfully created
          onSubmit({
            overrideCreatedAgentPolicy: createdPolicy,
            force: true
          });
        }
        return;
      }
      notifications.toasts.addError(error, {
        title: 'Error'
      });
      setFormState('VALID');
    }
  }, [formState, spaceId, hasErrors, agentCount, isAgentlessIntegration, packageInfo, selectedPolicyTab, packagePolicy, isAgentlessAgentPolicy, hasFleetAddAgentsPrivileges, withSysMonitoring, newAgentPolicy, updatePackagePolicy, notifications.toasts, agentPolicies, onSaveNavigate, confirmForceInstall, docLinks.links.fleet.agentlessIntegrations]);
  return {
    agentPolicies,
    updateAgentPolicies,
    packagePolicy,
    updatePackagePolicy,
    savedPackagePolicy,
    onSubmit,
    formState,
    setFormState,
    hasErrors,
    validationResults,
    setValidationResults,
    hasAgentPolicyError,
    setHasAgentPolicyError,
    isInitialized,
    // TODO check
    navigateAddAgent,
    navigateAddAgentHelp,
    handleSetupTechnologyChange,
    allowedSetupTechnologies,
    selectedSetupTechnology,
    defaultSetupTechnology,
    isAgentlessSelected
  };
}