"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.previewIndexTimeRange = previewIndexTimeRange;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the start and end time range in epoch milliseconds for a given set of documents
 * @param client IScopedClusterClient
 * @param timeField Time field name
 * @param pipeline ingest pipeline config
 * @param docs array of documents
 * @returns start and end time range in epoch milliseconds
 */
async function previewIndexTimeRange(client, timeField, pipeline, docs) {
  const resp = await client.asInternalUser.ingest.simulate({
    pipeline,
    docs: docs.map((doc, i) => ({
      _index: 'index',
      _id: `id${i}`,
      _source: doc
    }))
  });
  const timeFieldValues = resp.docs.map(doc => {
    var _doc$doc;
    return (_doc$doc = doc.doc) === null || _doc$doc === void 0 ? void 0 : _doc$doc._source[timeField];
  });
  const epochs = timeFieldValues.map(timeFieldValue => {
    var _dateMath$parse;
    return (_dateMath$parse = _datemath.default.parse(timeFieldValue)) === null || _dateMath$parse === void 0 ? void 0 : _dateMath$parse.valueOf();
  }).filter(epoch => epoch !== undefined);
  return {
    start: Math.min(...epochs),
    end: Math.max(...epochs)
  };
}