"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OperationTypeComponent = OperationTypeComponent;
exports.OperationTypeSelect = OperationTypeSelect;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_series_storage = require("../../hooks/use_series_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/columns/operation_type_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function OperationTypeSelect({
  seriesId,
  series,
  defaultOperationType
}) {
  const {
    setSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const operationType = series === null || series === void 0 ? void 0 : series.operationType;
  const onChange = value => {
    setSeries(seriesId, {
      ...series,
      operationType: value
    });
  };
  return /*#__PURE__*/_react.default.createElement(OperationTypeComponent, {
    onChange: onChange,
    operationType: operationType || defaultOperationType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  });
}
function OperationTypeComponent({
  operationType,
  onChange
}) {
  const options = [{
    value: 'min',
    inputDisplay: _i18n.i18n.translate('xpack.exploratoryView.expView.operationType.min', {
      defaultMessage: 'Min'
    })
  }, {
    value: 'max',
    inputDisplay: _i18n.i18n.translate('xpack.exploratoryView.expView.operationType.max', {
      defaultMessage: 'Max'
    })
  }, {
    value: 'average',
    inputDisplay: _i18n.i18n.translate('xpack.exploratoryView.expView.operationType.average', {
      defaultMessage: 'Average'
    })
  }, {
    value: 'median',
    inputDisplay: _i18n.i18n.translate('xpack.exploratoryView.expView.operationType.median', {
      defaultMessage: 'Median'
    })
  }, {
    value: 'sum',
    inputDisplay: _i18n.i18n.translate('xpack.exploratoryView.expView.operationType.sum', {
      defaultMessage: 'Sum'
    })
  }, {
    value: 'last_value',
    inputDisplay: _i18n.i18n.translate('xpack.exploratoryView.expView.operationType.lastValue', {
      defaultMessage: 'Last value'
    })
  }, {
    value: 'unique_count',
    inputDisplay: _i18n.i18n.translate('xpack.exploratoryView.expView.operationType.uniqueCount', {
      defaultMessage: 'Unique count'
    })
  }, {
    value: '25th',
    inputDisplay: _i18n.i18n.translate('xpack.exploratoryView.expView.operationType.25thPercentile', {
      defaultMessage: '25th Percentile'
    })
  }, {
    value: '75th',
    inputDisplay: _i18n.i18n.translate('xpack.exploratoryView.expView.operationType.75thPercentile', {
      defaultMessage: '75th Percentile'
    })
  }, {
    value: '90th',
    inputDisplay: _i18n.i18n.translate('xpack.exploratoryView.expView.operationType.90thPercentile', {
      defaultMessage: '90th Percentile'
    })
  }, {
    value: '95th',
    inputDisplay: _i18n.i18n.translate('xpack.exploratoryView.expView.operationType.95thPercentile', {
      defaultMessage: '95th Percentile'
    })
  }, {
    value: '99th',
    inputDisplay: _i18n.i18n.translate('xpack.exploratoryView.expView.operationType.99thPercentile', {
      defaultMessage: '99th Percentile'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    "data-test-subj": "operationTypeSelect",
    valueOfSelected: operationType,
    options: options,
    onChange: onChange,
    "aria-label": _i18n.i18n.translate('xpack.exploratoryView.expView.operationTypeSelect.ariaLabel', {
      defaultMessage: 'Operation type'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  });
}